/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsSource;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.drools.core.util.IoUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.scanner.MavenRepositoryConfiguration;
import org.kie.scanner.embedder.MavenEmbedder;
import org.kie.scanner.embedder.MavenEmbedderException;
import org.kie.scanner.embedder.MavenRequest;
import org.kie.scanner.embedder.MavenSettings;

public class MavenEmbedderTest {
    private final String EMPTY_SETTINGS = "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\"/>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalRepositories() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            if (oldSettingsXmlPath != null) {
                System.clearProperty("kie.maven.settings.custom");
            }
            MavenSettings.reinitSettingsFromString((String)"<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\"/>\n");
            MavenRequest mavenRequest = MavenEmbedderTest.createMavenRequest(null);
            MavenEmbedderMock embedder = new MavenEmbedderMock(mavenRequest);
            MavenExecutionRequest request = embedder.buildMavenExecutionRequest(mavenRequest);
            Assert.assertNotNull((Object)request);
            List remoteRepositories = request.getRemoteRepositories();
            Assert.assertEquals((long)2L, (long)remoteRepositories.size());
            for (ArtifactRepository remoteRepository : remoteRepositories) {
                Assert.assertTrue((remoteRepository.getId().equals("central") || remoteRepository.getId().equals("kie-wb-m2-repo") ? 1 : 0) != 0);
            }
        }
        catch (MavenEmbedderException mee) {
            Assert.fail((String)mee.getMessage());
        }
        catch (ComponentLookupException cle) {
            Assert.fail((String)cle.getMessage());
        }
        finally {
            if (oldSettingsXmlPath != null) {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }

    @Test
    public void testCustomSettingSource() {
        try {
            MavenRequest mavenRequest = MavenEmbedderTest.createMavenRequest(new SettingsSourceMock("<settings/>"));
            MavenEmbedderMock embedder = new MavenEmbedderMock(mavenRequest);
            MavenExecutionRequest request = embedder.buildMavenExecutionRequest(mavenRequest);
            Assert.assertNotNull((Object)request);
            Assert.assertEquals((Object)"<settings/>", (Object)IoUtils.readFileAsString((File)request.getUserSettingsFile()).trim());
        }
        catch (MavenEmbedderException mee) {
            Assert.fail((String)mee.getMessage());
        }
        catch (ComponentLookupException cle) {
            Assert.fail((String)cle.getMessage());
        }
    }

    private static MavenRequest createMavenRequest(SettingsSource settingsSource) {
        MavenRequest mavenRequest = new MavenRequest();
        mavenRequest.setLocalRepositoryPath(MavenSettings.getSettings().getLocalRepository());
        mavenRequest.setUserSettingsSource(settingsSource != null ? settingsSource : MavenSettings.getUserSettingsSource());
        mavenRequest.setResolveDependencies(true);
        mavenRequest.setOffline(true);
        return mavenRequest;
    }

    public static class SettingsSourceMock
    implements SettingsSource {
        private final String settings;

        public SettingsSourceMock(String settings) {
            this.settings = settings;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.settings.getBytes("UTF-8"));
        }

        public String getLocation() {
            return "test";
        }
    }

    public static class MavenEmbedderMock
    extends MavenEmbedder {
        public MavenEmbedderMock(MavenRequest mavenRequest) throws MavenEmbedderException {
            super(mavenRequest);
        }

        protected MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
            return new MavenRepositoryConfiguration(this.getMavenSettings());
        }

        private Settings getMavenSettings() {
            String path = ((Object)((Object)this)).getClass().getResource(".").toString().substring("file:".length());
            File testSettingsFile = new File(path + "settings_with_repositories.xml");
            Assert.assertTrue((boolean)testSettingsFile.exists());
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(testSettingsFile);
            try {
                return settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

