/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.builder.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.appformer.maven.integration.MavenRepository;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.EnvironmentImpl;
import org.drools.core.test.model.Cheese;
import org.junit.After;
import org.junit.Test;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.helper.FluentKieModuleDeploymentHelper;
import org.kie.api.builder.helper.KieModuleDeploymentHelper;
import org.kie.api.builder.helper.SingleKieModuleDeploymentHelper;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieModuleDeploymentHelperTest {
    protected static Logger logger = LoggerFactory.getLogger(KieModuleDeploymentHelperTest.class);
    private ZipInputStream zip;

    @After
    public void cleanUp() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSingleDeploymentHelper() throws Exception {
        int numFiles = 0;
        int numDirs = 0;
        SingleKieModuleDeploymentHelper deploymentHelper = KieModuleDeploymentHelper.newSingleInstance();
        ArrayList<String> resourceFilePaths = new ArrayList<String>();
        resourceFilePaths.add("builder/test/");
        numFiles += 2;
        resourceFilePaths.add("builder/simple_query_test.drl");
        ++numFiles;
        ArrayList<Class<Cheese>> kjarClasses = new ArrayList<Class<Cheese>>();
        kjarClasses.add(KieModuleDeploymentHelper.class);
        numDirs += 5;
        kjarClasses.add(EnvironmentImpl.class);
        numDirs += 3;
        kjarClasses.add(Cheese.class);
        ++numDirs;
        numFiles += 3;
        String groupId = "org.kie.api.builder";
        String artifactId = "test-kjar";
        String version = "0.1-SNAPSHOT";
        deploymentHelper.createKieJarAndDeployToMaven(groupId, artifactId, version, "defaultKieBase", "defaultKieSession", resourceFilePaths, kjarClasses);
        numFiles += 2;
        numFiles += 3;
        numDirs += 4;
        numDirs += 2;
        File artifactFile = MavenRepository.getMavenRepository().resolveArtifact(groupId + ":" + artifactId + ":" + version).getFile();
        this.zip = new ZipInputStream(new FileInputStream(artifactFile));
        HashSet<String> jarFiles = new HashSet<String>();
        HashSet<String> jarDirs = new HashSet<String>();
        ZipEntry ze = this.zip.getNextEntry();
        logger.debug("Getting files from deployed jar: ");
        while (ze != null) {
            String fileName = ze.getName();
            if (fileName.endsWith("drl") || fileName.endsWith("class") || fileName.endsWith("xml") || fileName.endsWith("info") || fileName.endsWith("properties") || fileName.endsWith("cache")) {
                jarFiles.add(fileName);
                logger.debug("> " + fileName);
            } else {
                jarDirs.add(fileName);
                logger.debug("] " + fileName);
            }
            ze = this.zip.getNextEntry();
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)jarFiles.size()).as("Num files in kjar", new Object[0])).isEqualTo(numFiles);
    }

    @Test
    public void testFluentDeploymentHelper() throws Exception {
        int numFiles = 0;
        int numDirs = 0;
        FluentKieModuleDeploymentHelper deploymentHelper = KieModuleDeploymentHelper.newFluentInstance();
        String groupId = "org.kie.api.builder.fluent";
        String artifactId = "test-kjar";
        String version = "0.1-SNAPSHOT";
        deploymentHelper = deploymentHelper.setGroupId(groupId).setArtifactId(artifactId).setVersion(version).addResourceFilePath(new String[]{"builder/test/", "builder/simple_query_test.drl"}).addResourceFilePath(new String[]{"/META-INF/WorkDefinitions.conf"}).addClass(new Class[]{KieModuleDeploymentHelperTest.class}).addClass(new Class[]{KieModule.class}).addClass(new Class[]{Cheese.class});
        numDirs += 5;
        numDirs += 2;
        numFiles += 3;
        numFiles += 2;
        numFiles += 2;
        numFiles += 2;
        ++numFiles;
        numFiles += 3;
        numDirs += 4;
        numDirs += 2;
        KieBaseModel kbaseModel = deploymentHelper.getKieModuleModel().newKieBaseModel("otherKieBase");
        kbaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kbaseModel.newKieSessionModel("otherKieSession").setClockType(ClockTypeOption.REALTIME);
        ++numDirs;
        ((KieBaseModel)deploymentHelper.getKieModuleModel().getKieBaseModels().get("defaultKieBase")).newKieSessionModel("secondKieSession");
        deploymentHelper.createKieJarAndDeployToMaven();
        File artifactFile = MavenRepository.getMavenRepository().resolveArtifact(groupId + ":" + artifactId + ":" + version).getFile();
        this.zip = new ZipInputStream(new FileInputStream(artifactFile));
        HashSet<String> jarFiles = new HashSet<String>();
        HashSet<String> jarDirs = new HashSet<String>();
        ZipEntry ze = this.zip.getNextEntry();
        logger.debug("Getting files form deployed jar: ");
        while (ze != null) {
            String fileName = ze.getName();
            if (fileName.endsWith("drl") || fileName.endsWith("class") || fileName.endsWith("tst") || fileName.endsWith("conf") || fileName.endsWith("xml") || fileName.endsWith("info") || fileName.endsWith("properties") || fileName.endsWith("cache")) {
                jarFiles.add(fileName);
                logger.debug("> " + fileName);
            } else {
                jarDirs.add(fileName);
                logger.debug("] " + fileName);
            }
            ze = this.zip.getNextEntry();
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)jarFiles.size()).as("Num files in kjar", new Object[0])).isEqualTo(numFiles);
    }
}

