/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.eclipse.aether.artifact.Artifact;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.utils.ClassLoaderResolver;
import org.kie.maven.integration.ArtifactResolver;
import org.kie.scanner.KieURLClassLoader;
import org.kie.util.maven.support.DependencyFilter;
import org.kie.util.maven.support.PomModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenClassLoaderResolver
implements ClassLoaderResolver {
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final Logger logger;

    public ClassLoader getClassLoader(KieModule kmodule) {
        Collection<ReleaseId> jarDependencies;
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (parent == null) {
            parent = MavenClassLoaderResolver.class.getClassLoader();
        }
        InternalKieModule internalKModule = (InternalKieModule)kmodule;
        ArtifactResolver resolver = null;
        if (internalKModule.getPomModel() == null) {
            resolver = ArtifactResolver.getResolverFor((PomModel)internalKModule.getPomModel());
            jarDependencies = this.getJarDependencies(resolver, kmodule.getReleaseId(), DependencyFilter.COMPILE_FILTER);
        } else {
            jarDependencies = internalKModule.getJarDependencies(DependencyFilter.COMPILE_FILTER);
        }
        if (jarDependencies.isEmpty()) {
            return parent;
        }
        if (resolver == null) {
            resolver = ArtifactResolver.getResolverFor((PomModel)internalKModule.getPomModel());
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<ReleaseId> unresolvedDeps = new ArrayList<ReleaseId>();
        for (ReleaseId rid : jarDependencies) {
            try {
                Artifact artifact = resolver.resolveArtifact(rid);
                if (artifact != null) {
                    File jar = artifact.getFile();
                    urls.add(jar.toURI().toURL());
                    continue;
                }
                logger.error("Dependency artifact not found for: " + rid);
                unresolvedDeps.add(rid);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        internalKModule.setUnresolvedDependencies(unresolvedDeps);
        return new KieURLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    private Collection<ReleaseId> getJarDependencies(ArtifactResolver resolver, ReleaseId releaseId, DependencyFilter filter) {
        return resolver.getArtifactDependecies(releaseId.toString()).stream().filter(dep -> filter.accept(dep.getReleaseId(), dep.getScope())).map(dep -> dep.getReleaseId()).collect(Collectors.toList());
    }

    static {
        logger = LoggerFactory.getLogger(MavenClassLoaderResolver.class);
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MavenClassLoaderResolver.class.getProtectionDomain();
            }
        });
    }
}

