/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.Adler32;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;

public class ZKLogFormatter {
    private static final Logger LOG = Logger.getLogger(ZKLogFormatter.class);
    private static DateFormat dateTimeInstance = DateFormat.getDateTimeInstance(3, 1);
    private static HexBinaryAdapter adapter = new HexBinaryAdapter();
    private static String fieldDelim = ":";
    private static String fieldSep = " ";
    static BufferedWriter bw = null;

    public static void main(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            System.err.println("USAGE: LogFormatter <log|snapshot> log_file");
            System.exit(2);
        }
        if (args.length == 3) {
            bw = new BufferedWriter(new FileWriter(new File(args[2])));
        }
        if (args[0].equals("log")) {
            ZKLogFormatter.readTransactionLog(args[1]);
        } else if (args[0].equals("snapshot")) {
            ZKLogFormatter.readSnapshotLog(args[1]);
        }
        if (bw != null) {
            bw.close();
        }
    }

    private static void readSnapshotLog(String snapshotPath) throws Exception {
        FileInputStream fis = new FileInputStream(snapshotPath);
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)fis);
        HashMap sessions = new HashMap();
        DataTree dt = new DataTree();
        FileHeader header = new FileHeader();
        header.deserialize((InputArchive)ia, "fileheader");
        if (header.getMagic() != FileSnap.SNAP_MAGIC) {
            throw new IOException("mismatching magic headers " + header.getMagic() + " !=  " + FileSnap.SNAP_MAGIC);
        }
        SerializeUtils.deserializeSnapshot((DataTree)dt, (InputArchive)ia, sessions);
        if (bw != null) {
            bw.write(((Object)sessions).toString());
            bw.newLine();
        } else {
            System.out.println(sessions);
        }
        ZKLogFormatter.traverse(dt, 1, "/");
    }

    private static void traverse(DataTree dt, int startId, String startPath) throws Exception {
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(new Pair(startPath, startId));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            String path = pair._path;
            DataNode head = dt.getNode(path);
            Stat stat = new Stat();
            byte[] data = null;
            try {
                data = dt.getData(path, stat, null);
            }
            catch (KeeperException.NoNodeException e) {
                e.printStackTrace();
            }
            ZKLogFormatter.format(startId, pair, head, data);
            Set children = head.getChildren();
            if (children != null) {
                for (String child : children) {
                    String childPath = path.endsWith("/") ? path + child : path + "/" + child;
                    queue.add(new Pair(childPath, startId));
                }
            }
            ++startId;
        }
    }

    private static void format(int id, Pair pair, DataNode head, byte[] data) throws Exception {
        String dataStr = "";
        if (data != null) {
            dataStr = new String(data).replaceAll("[\\s]+", "");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("id").append(fieldDelim).append(id).append(fieldSep);
        sb.append("parent").append(fieldDelim).append(pair._parentId).append(fieldSep);
        sb.append("path").append(fieldDelim).append(pair._path).append(fieldSep);
        sb.append("session").append(fieldDelim).append("0x" + Long.toHexString(head.stat.getEphemeralOwner())).append(fieldSep);
        sb.append("czxid").append(fieldDelim).append("0x" + Long.toHexString(head.stat.getCzxid())).append(fieldSep);
        sb.append("ctime").append(fieldDelim).append(head.stat.getCtime()).append(fieldSep);
        sb.append("mtime").append(fieldDelim).append(head.stat.getMtime()).append(fieldSep);
        sb.append("cmzxid").append(fieldDelim).append("0x" + Long.toHexString(head.stat.getMzxid())).append(fieldSep);
        sb.append("pzxid").append(fieldDelim).append("0x" + Long.toHexString(head.stat.getPzxid())).append(fieldSep);
        sb.append("aversion").append(fieldDelim).append(head.stat.getAversion()).append(fieldSep);
        sb.append("cversion").append(fieldDelim).append(head.stat.getCversion()).append(fieldSep);
        sb.append("version").append(fieldDelim).append(head.stat.getVersion()).append(fieldSep);
        sb.append("data").append(fieldDelim).append(dataStr).append(fieldSep);
        if (bw != null) {
            bw.write(sb.toString());
            bw.newLine();
        } else {
            System.out.println(sb);
        }
    }

    private static void readTransactionLog(String logfilepath) throws FileNotFoundException, IOException, EOFException {
        FileInputStream fis = new FileInputStream(logfilepath);
        BinaryInputArchive logStream = BinaryInputArchive.getArchive((InputStream)fis);
        FileHeader fhdr = new FileHeader();
        fhdr.deserialize((InputArchive)logStream, "fileheader");
        if (fhdr.getMagic() != FileTxnLog.TXNLOG_MAGIC) {
            System.err.println("Invalid magic number for " + logfilepath);
            System.exit(2);
        }
        if (bw != null) {
            bw.write("ZooKeeper Transactional Log File with dbid " + fhdr.getDbid() + " txnlog format version " + fhdr.getVersion());
            bw.newLine();
        } else {
            System.out.println("ZooKeeper Transactional Log File with dbid " + fhdr.getDbid() + " txnlog format version " + fhdr.getVersion());
        }
        int count = 0;
        while (true) {
            byte[] bytes;
            long crcValue;
            try {
                crcValue = logStream.readLong("crcvalue");
                bytes = logStream.readBuffer("txnEntry");
            }
            catch (EOFException e) {
                if (bw != null) {
                    bw.write("EOF reached after " + count + " txns.");
                    bw.newLine();
                    break;
                }
                System.out.println("EOF reached after " + count + " txns.");
                break;
            }
            if (bytes.length == 0) {
                if (bw != null) {
                    bw.write("EOF reached after " + count + " txns.");
                    bw.newLine();
                } else {
                    System.out.println("EOF reached after " + count + " txns.");
                }
                return;
            }
            Adler32 crc = new Adler32();
            crc.update(bytes, 0, bytes.length);
            if (crcValue != crc.getValue()) {
                throw new IOException("CRC doesn't match " + crcValue + " vs " + crc.getValue());
            }
            BinaryInputArchive iab = BinaryInputArchive.getArchive((InputStream)new ByteArrayInputStream(bytes));
            TxnHeader hdr = new TxnHeader();
            Record txn = SerializeUtils.deserializeTxn((InputArchive)iab, (TxnHeader)hdr);
            if (bw != null) {
                bw.write(ZKLogFormatter.formatTransaction(hdr, txn));
                bw.newLine();
            } else {
                System.out.println(ZKLogFormatter.formatTransaction(hdr, txn));
            }
            if (logStream.readByte("EOR") != 66) {
                LOG.error((Object)"Last transaction was partial.");
                throw new EOFException("Last transaction was partial.");
            }
            ++count;
        }
    }

    static String op2String(int op) {
        switch (op) {
            case 0: {
                return "notification";
            }
            case 1: {
                return "create";
            }
            case 2: {
                return "delete";
            }
            case 3: {
                return "exists";
            }
            case 4: {
                return "getDate";
            }
            case 5: {
                return "setData";
            }
            case 6: {
                return "getACL";
            }
            case 7: {
                return "setACL";
            }
            case 8: {
                return "getChildren";
            }
            case 12: {
                return "getChildren2";
            }
            case 11: {
                return "ping";
            }
            case -10: {
                return "createSession";
            }
            case -11: {
                return "closeSession";
            }
            case -1: {
                return "error";
            }
        }
        return "unknown " + op;
    }

    private static String formatTransaction(TxnHeader header, Record txn) {
        StringBuilder sb = new StringBuilder();
        sb.append("time").append(fieldDelim).append(header.getTime());
        sb.append(fieldSep).append("session").append(fieldDelim).append("0x").append(Long.toHexString(header.getClientId()));
        sb.append(fieldSep).append("cxid").append(fieldDelim).append("0x").append(Long.toHexString(header.getCxid()));
        sb.append(fieldSep).append("zxid").append(fieldDelim).append("0x").append(Long.toHexString(header.getZxid()));
        sb.append(fieldSep).append("type").append(fieldDelim).append(ZKLogFormatter.op2String(header.getType()));
        if (txn != null) {
            try {
                byte[] data = null;
                for (PropertyDescriptor pd : Introspector.getBeanInfo(txn.getClass()).getPropertyDescriptors()) {
                    if (pd.getName().equalsIgnoreCase("data")) {
                        data = (byte[])pd.getReadMethod().invoke((Object)txn, new Object[0]);
                        continue;
                    }
                    if (pd.getReadMethod() == null || "class".equals(pd.getName())) continue;
                    sb.append(fieldSep).append(pd.getDisplayName()).append(fieldDelim).append(pd.getReadMethod().invoke((Object)txn, new Object[0]).toString().replaceAll("[\\s]+", ""));
                }
                if (data != null) {
                    sb.append(fieldSep).append("data").append(fieldDelim).append(new String(data).replaceAll("[\\s]+", ""));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while retrieving bean property values for " + txn.getClass()), (Throwable)e);
            }
        }
        return sb.toString();
    }

    static class Pair {
        private final String _path;
        private final int _parentId;

        public Pair(String path, int parentId) {
            this._path = path;
            this._parentId = parentId;
        }
    }
}

