/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.discussion;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialCommandTypeFilter;
import org.kie.uberfire.social.activities.service.SocialUserRepositoryAPI;
import org.kie.workbench.common.services.shared.discussion.CommentAddedEvent;
import org.kie.workbench.common.services.shared.discussion.DiscussionEventTypes;

@ApplicationScoped
public class DiscussionAddedEventAdapter
implements SocialAdapter<CommentAddedEvent> {
    @Inject
    private SocialUserRepositoryAPI socialUserRepositoryAPI;

    public Class<CommentAddedEvent> eventToIntercept() {
        return CommentAddedEvent.class;
    }

    public SocialEventType socialEventType() {
        return DiscussionEventTypes.COMMENT_ADDED;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public void howdy(@Observes CommentAddedEvent event) {
    }

    public SocialActivitiesEvent toSocial(Object object) {
        CommentAddedEvent event = (CommentAddedEvent)object;
        SocialUser socialUser = this.socialUserRepositoryAPI.findSocialUser(event.getUserName());
        String additionalInfo = event.getUserName() + " commented on " + event.getPath().getFileName();
        return new SocialActivitiesEvent(socialUser, DiscussionEventTypes.COMMENT_ADDED.name(), new Date(event.getTimestamp())).withLink(event.getPath().getFileName(), event.getPath().toURI()).withAdicionalInfo(new String[]{additionalInfo});
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }
}

