/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery;
import org.kie.workbench.common.screens.explorer.utils.Sorters;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

public class ProjectExplorerContentResolver {
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    private KieProjectService projectService;
    private ExplorerServiceHelper helper;
    private AuthorizationManager authorizationManager;
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    @SessionScoped
    protected User identity;
    private OrganizationalUnit selectedOrganizationalUnit;
    private Repository selectedRepository;
    private Project selectedProject;
    private Package selectedPackage;
    private FolderItem selectedItem;
    private FolderListing folderListing;
    private Map<FolderItem, List<FolderItem>> siblings;
    private Set<OrganizationalUnit> organizationalUnits;
    private Map<String, Repository> repositories;
    private Map<String, Project> projects;

    public ProjectExplorerContentResolver() {
    }

    @Inject
    public ProjectExplorerContentResolver(KieProjectService projectService, ExplorerServiceHelper helper, AuthorizationManager authorizationManager, OrganizationalUnitService organizationalUnitService) {
        this.projectService = projectService;
        this.helper = helper;
        this.authorizationManager = authorizationManager;
        this.organizationalUnitService = organizationalUnitService;
    }

    public ProjectExplorerContent resolve(ProjectExplorerContentQuery query) {
        this.setupSelectedItems(query);
        this.setSelectedOrganizationalUnit();
        this.setSelectedRepository();
        this.setSelectedProject();
        if (this.selectedOrganizationalUnit == null || this.selectedRepository == null || this.selectedProject == null) {
            return this.emptyProjectExplorerContent();
        }
        return this.projectExplorerContentWithSelections(query.getOptions());
    }

    private ProjectExplorerContent projectExplorerContentWithSelections(Set<Option> options) {
        this.setFolderListing(options);
        this.setSiblings();
        this.helper.store(this.selectedOrganizationalUnit, this.selectedRepository, this.selectedProject, this.folderListing, this.selectedPackage, options);
        return new ProjectExplorerContent((Set)new TreeSet<OrganizationalUnit>(Sorters.ORGANIZATIONAL_UNIT_SORTER){
            {
                this.addAll(ProjectExplorerContentResolver.this.organizationalUnits);
            }
        }, this.selectedOrganizationalUnit, (Set)new TreeSet<Repository>(Sorters.REPOSITORY_SORTER){
            {
                this.addAll(ProjectExplorerContentResolver.this.repositories.values());
            }
        }, this.selectedRepository, (Set)new TreeSet<Project>(Sorters.PROJECT_SORTER){
            {
                this.addAll(ProjectExplorerContentResolver.this.projects.values());
            }
        }, this.selectedProject, this.folderListing, this.siblings);
    }

    private void setFolderListing(Set<Option> options) {
        this.folderListing = this.helper.getFolderListing(this.selectedItem, this.selectedProject, this.selectedPackage, options);
    }

    private void setSiblings() {
        ArrayList<FolderItem> result;
        if (this.folderListing.getSegments().size() > 1) {
            ListIterator li = this.folderListing.getSegments().listIterator(this.folderListing.getSegments().size());
            while (li.hasPrevious()) {
                FolderItem currentItem = (FolderItem)li.previous();
                ArrayList<FolderItem> result2 = new ArrayList<FolderItem>();
                if (currentItem.getItem() instanceof Package) {
                    result2.addAll(this.getSegmentSiblings((Package)currentItem.getItem()));
                } else if (currentItem.getItem() instanceof org.uberfire.backend.vfs.Path) {
                    result2.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)currentItem.getItem()));
                }
                this.siblings.put(currentItem, result2);
            }
        }
        if (this.selectedItem != null && this.selectedItem.getType().equals((Object)FolderItemType.FOLDER) && !this.siblings.containsKey(this.selectedItem)) {
            result = new ArrayList<FolderItem>();
            if (this.selectedItem.getItem() instanceof Package) {
                result.addAll(this.getSegmentSiblings((Package)this.selectedItem.getItem()));
            } else if (this.selectedItem.getItem() instanceof org.uberfire.backend.vfs.Path) {
                result.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)this.selectedItem.getItem()));
            }
            this.siblings.put(this.selectedItem, result);
        }
        if (this.folderListing.getItem().getType().equals((Object)FolderItemType.FOLDER) && !this.siblings.containsKey(this.folderListing.getItem())) {
            result = new ArrayList();
            if (this.folderListing.getItem().getItem() instanceof Package) {
                result.addAll(this.getSegmentSiblings((Package)this.folderListing.getItem().getItem()));
            } else if (this.folderListing.getItem().getItem() instanceof org.uberfire.backend.vfs.Path) {
                result.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)this.folderListing.getItem().getItem()));
            }
            if (!result.isEmpty()) {
                this.siblings.put(this.folderListing.getItem(), result);
            }
        }
    }

    private ProjectExplorerContent emptyProjectExplorerContent() {
        return new ProjectExplorerContent((Set)new TreeSet<OrganizationalUnit>(Sorters.ORGANIZATIONAL_UNIT_SORTER){
            {
                this.addAll(ProjectExplorerContentResolver.this.organizationalUnits);
            }
        }, this.selectedOrganizationalUnit, (Set)new TreeSet<Repository>(Sorters.REPOSITORY_SORTER){
            {
                this.addAll(ProjectExplorerContentResolver.this.repositories.values());
            }
        }, this.selectedRepository, (Set)new TreeSet<Project>(Sorters.PROJECT_SORTER){
            {
                this.addAll(ProjectExplorerContentResolver.this.projects.values());
            }
        }, this.selectedProject, new FolderListing(null, Collections.emptyList(), Collections.emptyList()), Collections.emptyMap());
    }

    private void setSelectedProject() {
        this.projects = this.getProjects(this.selectedRepository);
        this.selectedProject = this.selectedProject == null || !this.projects.containsKey(this.selectedProject.getProjectName()) ? (this.projects.isEmpty() ? null : this.projects.values().iterator().next()) : this.projects.get(this.selectedProject.getProjectName());
    }

    private void setSelectedRepository() {
        this.repositories = this.getRepositories(this.selectedOrganizationalUnit);
        if (this.selectedRepository == null || !this.repositories.containsKey(this.selectedRepository.getAlias())) {
            this.selectedRepository = this.repositories.isEmpty() ? null : this.repositories.values().iterator().next();
        } else if (this.isCurrentRepositoryUpToDate()) {
            String branch = this.selectedRepository.getCurrentBranch();
            this.selectedRepository = this.repositories.get(this.selectedRepository.getAlias());
            if (this.selectedRepository instanceof GitRepository) {
                ((GitRepository)this.selectedRepository).changeBranch(branch);
            }
        }
    }

    private boolean isCurrentRepositoryUpToDate() {
        return !this.selectedRepository.equals(this.repositories.get(this.selectedRepository.getAlias()));
    }

    private void setSelectedOrganizationalUnit() {
        this.organizationalUnits = this.getOrganizationalUnits();
        if (!this.organizationalUnits.contains(this.selectedOrganizationalUnit)) {
            this.selectedOrganizationalUnit = this.organizationalUnits.isEmpty() ? null : this.organizationalUnits.iterator().next();
        }
    }

    private void setupSelectedItems(ProjectExplorerContentQuery query) {
        this.clear(query);
        UserExplorerLastData lastContent = this.helper.getLastContent();
        UserExplorerData userContent = this.helper.loadUserContent();
        if (!lastContent.isDataEmpty()) {
            if (query.getOrganizationalUnit() == null && query.getRepository() == null && query.getProject() == null) {
                if (query.getOptions().contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                    this.selectedOrganizationalUnit = lastContent.getLastPackage().getOrganizationalUnit();
                    this.selectedRepository = lastContent.getLastPackage().getRepository();
                    this.selectedProject = lastContent.getLastPackage().getProject();
                    this.selectedPackage = lastContent.getLastPackage().getPkg();
                    this.selectedItem = null;
                } else if (query.getOptions().contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null) {
                    this.selectedOrganizationalUnit = lastContent.getLastFolderItem().getOrganizationalUnit();
                    this.selectedRepository = lastContent.getLastFolderItem().getRepository();
                    this.selectedProject = lastContent.getLastFolderItem().getProject();
                    this.selectedItem = lastContent.getLastFolderItem().getItem();
                    this.selectedPackage = null;
                }
            } else if (query.getOptions().contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                if (!query.getOrganizationalUnit().equals(lastContent.getLastPackage().getOrganizationalUnit()) || query.getRepository() != null && !query.getRepository().equals(lastContent.getLastPackage().getRepository()) || query.getProject() != null && !query.getProject().equals((Object)lastContent.getLastPackage().getProject())) {
                    this.selectedOrganizationalUnit = this.loadOrganizationalUnit(query.getOrganizationalUnit(), userContent);
                    this.selectedRepository = this.loadRepository(this.selectedOrganizationalUnit, query.getRepository(), userContent);
                    this.selectedProject = this.loadProject(this.selectedOrganizationalUnit, this.selectedRepository, query.getProject(), userContent);
                    this.selectedPackage = this.loadPackage(this.selectedOrganizationalUnit, this.selectedRepository, this.selectedProject, query.getPkg(), userContent);
                    this.selectedItem = null;
                }
            } else if (query.getOptions().contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null && (!query.getOrganizationalUnit().equals(lastContent.getLastFolderItem().getOrganizationalUnit()) || query.getRepository() != null && !query.getRepository().equals(lastContent.getLastFolderItem().getRepository()) || query.getProject() != null && !query.getProject().equals((Object)lastContent.getLastFolderItem().getProject()))) {
                this.selectedOrganizationalUnit = this.loadOrganizationalUnit(query.getOrganizationalUnit(), userContent);
                this.selectedRepository = this.loadRepository(this.selectedOrganizationalUnit, query.getRepository(), userContent);
                this.selectedProject = this.loadProject(this.selectedOrganizationalUnit, this.selectedRepository, query.getProject(), userContent);
                this.selectedItem = this.loadFolderItem(this.selectedOrganizationalUnit, this.selectedRepository, this.selectedProject, query.getItem(), userContent);
                this.selectedPackage = null;
            }
        }
    }

    private void clear(ProjectExplorerContentQuery query) {
        this.selectedOrganizationalUnit = query.getOrganizationalUnit();
        this.selectedRepository = query.getRepository();
        this.selectedProject = query.getProject();
        this.selectedPackage = query.getPkg();
        this.selectedItem = query.getItem();
        this.folderListing = null;
        this.siblings = new HashMap<FolderItem, List<FolderItem>>();
    }

    private List<FolderItem> getSegmentSiblings(org.uberfire.backend.vfs.Path path) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Path nioParentPath = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent();
        for (Path sibling : Files.newDirectoryStream((Path)nioParentPath, (DirectoryStream.Filter)this.dotFileFilter)) {
            result.add(ExplorerServiceHelper.toFolderItem(sibling));
        }
        return result;
    }

    private List<FolderItem> getSegmentSiblings(Package pkg) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Package parentPkg = this.projectService.resolveParentPackage(pkg);
        if (parentPkg == null) {
            return Collections.emptyList();
        }
        Set siblings = this.projectService.resolvePackages(parentPkg);
        if (siblings != null && !siblings.isEmpty()) {
            for (Package sibling : siblings) {
                if (sibling.equals((Object)pkg)) continue;
                result.add(ExplorerServiceHelper.toFolderItem(sibling));
            }
        }
        return result;
    }

    private OrganizationalUnit loadOrganizationalUnit(OrganizationalUnit organizationalUnit, UserExplorerData content) {
        if (organizationalUnit != null) {
            return organizationalUnit;
        }
        return content.getOrganizationalUnit();
    }

    private Repository loadRepository(OrganizationalUnit organizationalUnit, Repository repository, UserExplorerData content) {
        if (organizationalUnit == null) {
            return null;
        }
        if (repository != null) {
            return repository;
        }
        return content.get(organizationalUnit);
    }

    private Project loadProject(OrganizationalUnit organizationalUnit, Repository repository, Project project, UserExplorerData content) {
        if (repository == null) {
            return null;
        }
        if (project != null) {
            return project;
        }
        return content.get(organizationalUnit, repository);
    }

    private Package loadPackage(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg, UserExplorerData content) {
        if (project == null) {
            return null;
        }
        if (pkg != null) {
            return pkg;
        }
        return content.getPackage(organizationalUnit, repository, project);
    }

    private FolderItem loadFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Project project, FolderItem item, UserExplorerData content) {
        if (project == null) {
            return null;
        }
        if (item != null) {
            return item;
        }
        return content.getFolderItem(organizationalUnit, repository, project);
    }

    private Set<OrganizationalUnit> getOrganizationalUnits() {
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        HashSet<OrganizationalUnit> authorizedOrganizationalUnits = new HashSet<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            if (!this.authorizationManager.authorize((Resource)organizationalUnit, this.identity)) continue;
            authorizedOrganizationalUnits.add(organizationalUnit);
        }
        return authorizedOrganizationalUnits;
    }

    private Map<String, Repository> getRepositories(OrganizationalUnit organizationalUnit) {
        HashMap<String, Repository> authorizedRepositories = new HashMap<String, Repository>();
        if (organizationalUnit == null) {
            return authorizedRepositories;
        }
        Collection repositories = this.organizationalUnitService.getOrganizationalUnit(organizationalUnit.getName()).getRepositories();
        for (Repository repository : repositories) {
            if (!this.authorizationManager.authorize((Resource)repository, this.identity)) continue;
            authorizedRepositories.put(repository.getAlias(), repository);
        }
        return authorizedRepositories;
    }

    private Map<String, Project> getProjects(Repository repository) {
        HashMap<String, Project> authorizedProjects = new HashMap<String, Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        Set allProjects = this.projectService.getProjects(repository, repository.getCurrentBranch());
        for (Project project : allProjects) {
            if (!this.authorizationManager.authorize((Resource)project, this.identity)) continue;
            authorizedProjects.put(project.getProjectName(), project);
        }
        return authorizedProjects;
    }
}

