/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.drools.core.io.impl.ReaderInputStream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.guvnor.common.services.project.model.GAV;
import org.kie.scanner.Aether;
import org.kie.scanner.embedder.MavenSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GuvnorM2Repository {
    private static final Logger log = LoggerFactory.getLogger(GuvnorM2Repository.class);
    public static final String M2_REPO_ROOT = "repositories" + File.separatorChar + "kie";
    public static String M2_REPO_DIR;
    private static final int BUFFER_SIZE = 1024;

    @PostConstruct
    protected void init() {
        this.setM2Repos();
    }

    private void setM2Repos() {
        String meReposDir = System.getProperty("org.guvnor.m2repo.dir");
        M2_REPO_DIR = meReposDir == null || meReposDir.trim().isEmpty() ? M2_REPO_ROOT : meReposDir.trim();
        log.info("Maven Repository root set to: " + M2_REPO_DIR);
        File root = new File(this.getM2RepositoryRootDir());
        if (!root.exists()) {
            log.info("Creating Maven Repository root: " + M2_REPO_DIR);
            root.mkdirs();
        }
        Aether.getAether().getRepositories().add(this.getGuvnorM2Repository());
    }

    public String getM2RepositoryRootDir() {
        if (!M2_REPO_DIR.endsWith(File.separator)) {
            return M2_REPO_DIR + File.separator;
        }
        return M2_REPO_DIR;
    }

    public String getRepositoryURL() {
        File file = new File(this.getM2RepositoryRootDir());
        return "file://" + file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployArtifact(InputStream inputStream, GAV gav, boolean includeAdditionalRepositories) {
        File jarFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, "jar"));
        try {
            String pomProperties;
            try {
                if (!jarFile.exists()) {
                    jarFile.getParentFile().mkdirs();
                    jarFile.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(jarFile);
                byte[] buf = new byte[1024];
                int byteRead = 0;
                while ((byteRead = inputStream.read(buf)) != -1) {
                    fos.write(buf, 0, byteRead);
                }
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String pomXML = GuvnorM2Repository.loadPOMFromJarInternal(new File(jarFile.getPath()));
            if (pomXML == null) {
                pomXML = this.generatePOM(gav);
                jarFile = this.appendPOMToJar(pomXML, jarFile.getPath(), gav);
            }
            if ((pomProperties = this.loadGAVFromJarInternal(new File(jarFile.getPath()))) == null) {
                pomProperties = GuvnorM2Repository.generatePomProperties(gav);
                jarFile = this.appendPomPropertiesToJar(pomProperties, jarFile.getPath(), gav);
            }
            this.deployArtifact(gav, pomXML, jarFile, includeAdditionalRepositories);
        }
        finally {
            try {
                jarFile.delete();
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary file '" + jarFile.getAbsolutePath() + "'");
            }
        }
    }

    public void deployArtifactInternal(InputStream is, GAV gav) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployParentPom(GAV gav) {
        File pomXMLFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, "pom.xml"));
        try {
            String pomXML = this.generateParentPOM(gav);
            try {
                if (!pomXMLFile.exists()) {
                    pomXMLFile.getParentFile().mkdirs();
                    pomXMLFile.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(pomXMLFile);
                IOUtils.write((String)pomXML, (OutputStream)fos);
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DefaultArtifact pomXMLArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "pom", gav.getVersion());
            pomXMLArtifact = pomXMLArtifact.setFile(pomXMLFile);
            try {
                InstallRequest installRequest = new InstallRequest();
                installRequest.addArtifact((Artifact)pomXMLArtifact);
                Aether.getAether().getSystem().install(Aether.getAether().getSession(), installRequest);
            }
            catch (InstallationException e) {
                throw new RuntimeException(e);
            }
            try {
                DeployRequest deployRequest = new DeployRequest();
                deployRequest.addArtifact((Artifact)pomXMLArtifact).setRepository(this.getGuvnorM2Repository());
                Aether.getAether().getSystem().deploy(Aether.getAether().getSession(), deployRequest);
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                pomXMLFile.delete();
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary file '" + pomXMLFile.getAbsolutePath() + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployArtifact(GAV gav, String pomXML, File jarFile, boolean includeAdditionalRepositories) {
        File pomXMLFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, "pom.xml"));
        try {
            try {
                if (!pomXMLFile.exists()) {
                    pomXMLFile.getParentFile().mkdirs();
                    pomXMLFile.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(pomXMLFile);
                IOUtils.write((String)pomXML, (OutputStream)fos);
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DefaultArtifact jarArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "jar", gav.getVersion());
            jarArtifact = jarArtifact.setFile(jarFile);
            SubArtifact pomXMLArtifact = new SubArtifact((Artifact)jarArtifact, "", "pom");
            pomXMLArtifact = pomXMLArtifact.setFile(pomXMLFile);
            try {
                InstallRequest installRequest = new InstallRequest();
                installRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomXMLArtifact);
                Aether.getAether().getSystem().install(Aether.getAether().getSession(), installRequest);
            }
            catch (InstallationException e) {
                throw new RuntimeException(e);
            }
            try {
                DeployRequest deployRequest = new DeployRequest();
                deployRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomXMLArtifact).setRepository(this.getGuvnorM2Repository());
                Aether.getAether().getSystem().deploy(Aether.getAether().getSession(), deployRequest);
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
            if (!includeAdditionalRepositories) {
                return;
            }
            try {
                Model model = new MavenXpp3Reader().read((Reader)new StringReader(pomXML));
                DistributionManagement distributionManagement = model.getDistributionManagement();
                if (distributionManagement != null) {
                    boolean isSnapshot = pomXMLArtifact.isSnapshot();
                    DeploymentRepository remoteRepository = null;
                    remoteRepository = isSnapshot ? distributionManagement.getSnapshotRepository() : distributionManagement.getRepository();
                    if (remoteRepository != null) {
                        DeployRequest remoteRequest = new DeployRequest();
                        remoteRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomXMLArtifact).setRepository(this.getRemoteRepoFromDeployment(remoteRepository));
                        Aether.getAether().getSystem().deploy(Aether.getAether().getSession(), remoteRequest);
                    }
                }
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
            catch (XmlPullParserException xppe) {
                throw new RuntimeException(xppe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        finally {
            try {
                pomXMLFile.delete();
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary file '" + pomXMLFile.getAbsolutePath() + "'");
            }
        }
    }

    private RemoteRepository getGuvnorM2Repository() {
        File m2RepoDir = new File(M2_REPO_DIR);
        if (!m2RepoDir.exists()) {
            log.error("Repository root does not exist: " + M2_REPO_DIR);
            throw new IllegalArgumentException("Repository root does not exist: " + M2_REPO_DIR);
        }
        try {
            String localRepositoryUrl = m2RepoDir.toURI().toURL().toExternalForm();
            return new RemoteRepository.Builder("guvnor-m2-repo", "default", localRepositoryUrl).setSnapshotPolicy(new RepositoryPolicy(true, "daily", "warn")).setReleasePolicy(new RepositoryPolicy(true, "always", "warn")).build();
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private RemoteRepository getRemoteRepoFromDeployment(DeploymentRepository repo) {
        RemoteRepository.Builder remoteRepoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl()).setSnapshotPolicy(new RepositoryPolicy(true, "daily", "warn")).setReleasePolicy(new RepositoryPolicy(true, "always", "warn"));
        Settings settings = MavenSettings.getSettings();
        Server server = settings.getServer(repo.getId());
        if (server != null) {
            remoteRepoBuilder.setAuthentication(new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).build());
        }
        return remoteRepoBuilder.build();
    }

    public Collection<File> listFiles() {
        return this.listFiles(null);
    }

    public Collection<File> listFiles(String filters) {
        String wildcard = "*.jar";
        if (filters != null) {
            wildcard = "*" + filters + "*.jar";
        }
        Collection files = FileUtils.listFiles((File)new File(M2_REPO_DIR), (IOFileFilter)new WildcardFileFilter(wildcard, IOCase.INSENSITIVE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        return files;
    }

    public InputStream loadFile(String path) {
        try {
            return new FileInputStream(new File(M2_REPO_DIR, path));
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public String getFileName(String path) {
        return new File(M2_REPO_DIR, path).getName();
    }

    public static String loadPOMFromJar(String jarPath) {
        File zip = new File(M2_REPO_DIR, jarPath);
        return GuvnorM2Repository.loadPOMFromJarInternal(zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadPOMFromJarInternal(File file) {
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (true) {
                if (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().startsWith("META-INF/maven") || !entry.getName().endsWith("pom.xml")) continue;
                    is = zip.getInputStream(entry);
                    isr = new InputStreamReader(is, "UTF-8");
                    StringBuilder sb = new StringBuilder();
                    int c = isr.read();
                    while (c != -1) {
                        sb.append((char)c);
                        c = isr.read();
                    }
                    String string = sb.toString();
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (ZipException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public GAV loadGAVFromJar(String jarPath) {
        File zip = new File(M2_REPO_DIR, jarPath);
        try {
            String pomProperties = this.loadGAVFromJarInternal(zip);
            Properties props = new Properties();
            props.load(new StringReader(pomProperties));
            String groupId = props.getProperty("groupId");
            String artifactId = props.getProperty("artifactId");
            String version = props.getProperty("version");
            return new GAV(groupId, artifactId, version);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadGAVFromJarInternal(File file) {
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (true) {
                if (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().startsWith("META-INF/maven") || !entry.getName().endsWith("pom.properties")) continue;
                    is = zip.getInputStream(entry);
                    isr = new InputStreamReader(is, "UTF-8");
                    StringBuilder sb = new StringBuilder();
                    int c = isr.read();
                    while (c != -1) {
                        sb.append((char)c);
                        c = isr.read();
                    }
                    String string = sb.toString();
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (ZipException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public static String loadPOMFromJar(InputStream jarInputStream) {
        try {
            InputStream is = GuvnorM2Repository.getInputStreamFromJar(jarInputStream, "META-INF/maven", "pom.xml");
            StringBuilder sb = new StringBuilder();
            int c = is.read();
            while (c != -1) {
                sb.append((char)c);
                c = is.read();
            }
            return sb.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String loadPOMPropertiesFromJar(InputStream jarInputStream) {
        try {
            InputStream is = GuvnorM2Repository.getInputStreamFromJar(jarInputStream, "META-INF/maven", "pom.properties");
            StringBuilder sb = new StringBuilder();
            int c = is.read();
            while (c != -1) {
                sb.append((char)c);
                c = is.read();
            }
            return sb.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static InputStream getInputStreamFromJar(InputStream jarInputStream, String prefix, String suffix) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(jarInputStream);
        while ((entry = zis.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (!entryName.startsWith(prefix) || !entryName.endsWith(suffix)) continue;
            return new ReaderInputStream((Reader)new InputStreamReader((InputStream)zis, "UTF-8"));
        }
        throw new FileNotFoundException("Could not find '" + prefix + "/*/" + suffix + "' in the jar.");
    }

    private File appendPOMToJar(String pom, String jarPath, GAV gav) {
        File originalJarFile = new File(jarPath);
        File appendedJarFile = new File(jarPath + ".tmp");
        try {
            ZipEntry e;
            ZipFile war = new ZipFile(originalJarFile);
            ZipOutputStream append = new ZipOutputStream(new FileOutputStream(appendedJarFile));
            Enumeration<? extends ZipEntry> entries = war.entries();
            while (entries.hasMoreElements()) {
                e = entries.nextElement();
                append.putNextEntry(e);
                if (!e.isDirectory()) {
                    IOUtil.copy((InputStream)war.getInputStream(e), (OutputStream)append);
                }
                append.closeEntry();
            }
            e = new ZipEntry(this.getPomXmlPath(gav));
            append.putNextEntry(e);
            append.write(pom.getBytes());
            append.closeEntry();
            war.close();
            append.close();
        }
        catch (ZipException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return appendedJarFile;
    }

    private File appendPomPropertiesToJar(String pomProperties, String jarPath, GAV gav) {
        File originalJarFile = new File(jarPath);
        File appendedJarFile = new File(jarPath + ".tmp");
        try {
            ZipEntry e;
            ZipFile war = new ZipFile(originalJarFile);
            ZipOutputStream append = new ZipOutputStream(new FileOutputStream(appendedJarFile));
            Enumeration<? extends ZipEntry> entries = war.entries();
            while (entries.hasMoreElements()) {
                e = entries.nextElement();
                append.putNextEntry(e);
                if (!e.isDirectory()) {
                    IOUtil.copy((InputStream)war.getInputStream(e), (OutputStream)append);
                }
                append.closeEntry();
            }
            e = new ZipEntry(this.getPomPropertiesPath(gav));
            append.putNextEntry(e);
            append.write(pomProperties.getBytes());
            append.closeEntry();
            war.close();
            append.close();
        }
        catch (ZipException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return appendedJarFile;
    }

    protected String toFileName(GAV gav, String fileName) {
        return gav.getGroupId() + "-" + gav.getArtifactId() + "-" + gav.getVersion() + "-" + Math.random() + "." + fileName;
    }

    public String generatePOM(GAV gav) {
        Model model = new Model();
        model.setGroupId(gav.getGroupId());
        model.setArtifactId(gav.getArtifactId());
        model.setVersion(gav.getVersion());
        model.setModelVersion("4.0.0");
        StringWriter stringWriter = new StringWriter();
        try {
            new MavenXpp3Writer().write((Writer)stringWriter, model);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return stringWriter.toString();
    }

    public static String generatePomProperties(GAV gav) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(gav.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(gav.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(gav.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    public String getPomXmlPath(GAV gav) {
        return "META-INF/maven/" + gav.getGroupId() + "/" + gav.getArtifactId() + "/pom.xml";
    }

    public String getPomPropertiesPath(GAV gav) {
        return "META-INF/maven/" + gav.getGroupId() + "/" + gav.getArtifactId() + "/pom.properties";
    }

    public String generateParentPOM(GAV gav) {
        Model model = new Model();
        model.setGroupId(gav.getGroupId());
        model.setArtifactId(gav.getArtifactId());
        model.setVersion(gav.getVersion());
        model.setPackaging("pom");
        model.setModelVersion("4.0.0");
        StringWriter stringWriter = new StringWriter();
        try {
            new MavenXpp3Writer().write((Writer)stringWriter, model);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return stringWriter.toString();
    }
}

