/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.query.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kie.internal.jaxb.StringKeyObjectValueMapXmlAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class QueryParameters {
    @XmlTransient
    private boolean union = true;
    @XmlTransient
    private boolean like = false;
    @XmlTransient
    private boolean range = false;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringKeyObjectValueMapXmlAdapter.class)
    private Map<String, List<? extends Object>> unionParameters = null;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringKeyObjectValueMapXmlAdapter.class)
    private Map<String, List<? extends Object>> intersectParameters = null;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringKeyObjectValueMapXmlAdapter.class)
    private Map<String, List<String>> unionRegexParameters = null;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringKeyObjectValueMapXmlAdapter.class)
    private Map<String, List<String>> intersectRegexParameters = null;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringKeyObjectValueMapXmlAdapter.class)
    private Map<String, List<? extends Object>> unionRangeParameters = null;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringKeyObjectValueMapXmlAdapter.class)
    private Map<String, List<? extends Object>> intersectRangeParameters = null;

    public QueryParameters() {
    }

    public Map<String, List<? extends Object>> getUnionParameters() {
        if (this.unionParameters == null) {
            this.unionParameters = new HashMap<String, List<? extends Object>>();
        }
        return this.unionParameters;
    }

    public boolean unionParametersAreEmpty() {
        return this.unionParameters == null ? true : this.unionParameters.isEmpty();
    }

    public Map<String, List<? extends Object>> getIntersectParameters() {
        if (this.intersectParameters == null) {
            this.intersectParameters = new HashMap<String, List<? extends Object>>();
        }
        return this.intersectParameters;
    }

    public boolean intersectParametersAreEmpty() {
        return this.intersectParameters == null ? true : this.intersectParameters.isEmpty();
    }

    public Map<String, List<String>> getUnionRegexParameters() {
        if (this.unionRegexParameters == null) {
            this.unionRegexParameters = new HashMap<String, List<String>>();
        }
        return this.unionRegexParameters;
    }

    public boolean unionRegexParametersAreEmpty() {
        return this.unionRegexParameters == null ? true : this.unionRegexParameters.isEmpty();
    }

    public Map<String, List<String>> getIntersectRegexParameters() {
        if (this.intersectRegexParameters == null) {
            this.intersectRegexParameters = new HashMap<String, List<String>>();
        }
        return this.intersectRegexParameters;
    }

    public boolean intersectRegexParametersAreEmpty() {
        return this.intersectRegexParameters == null ? true : this.intersectRegexParameters.isEmpty();
    }

    public Map<String, List<? extends Object>> getUnionRangeParameters() {
        if (this.unionRangeParameters == null) {
            this.unionRangeParameters = new HashMap<String, List<? extends Object>>();
        }
        return this.unionRangeParameters;
    }

    public boolean unionRangeParametersAreEmpty() {
        return this.unionRangeParameters == null ? true : this.unionRangeParameters.isEmpty();
    }

    public Map<String, List<? extends Object>> getIntersectRangeParameters() {
        if (this.intersectRangeParameters == null) {
            this.intersectRangeParameters = new HashMap<String, List<? extends Object>>();
        }
        return this.intersectRangeParameters;
    }

    public boolean intersectRangeParametersAreEmpty() {
        return this.intersectRangeParameters == null ? true : this.intersectRangeParameters.isEmpty();
    }

    public <T> void addAppropriateParam(String listId, T ... param) {
        if (param.length == 0) {
            return;
        }
        List<T> listParams = this.getAppropriateParamList(listId, param[0], param.length);
        listParams.addAll(Arrays.asList(param));
    }

    public <T> void addRangeParameter(String listId, T param, boolean start) {
        this.range = true;
        List<T> listParams = this.getAppropriateParamList(listId, param, 2);
        int index = start ? 0 : 1;
        listParams.set(index, param);
        this.range = false;
    }

    public <T> List<T> getAppropriateParamList(String listId, T param, int size) {
        List<? extends Object> listParams = null;
        if (this.like) {
            if (!(param instanceof String)) {
                throw new IllegalArgumentException("Only String parameters may be used in regular expressions.");
            }
            ArrayList stringListParams = null;
            if (this.union) {
                listParams = this.getUnionRegexParameters().get(listId);
                if (listParams == null) {
                    stringListParams = new ArrayList(size);
                    this.getUnionRegexParameters().put(listId, stringListParams);
                }
            } else {
                listParams = this.getIntersectParameters().get(listId);
                if (listParams == null) {
                    stringListParams = new ArrayList(size);
                    this.getIntersectRegexParameters().put(listId, stringListParams);
                }
            }
            if (listParams == null) {
                return stringListParams;
            }
            return listParams;
        }
        if (this.range) {
            if (this.union) {
                listParams = this.getUnionRangeParameters().get(listId);
                if (listParams == null) {
                    listParams = Arrays.asList(null, null);
                    this.getUnionRangeParameters().put(listId, listParams);
                }
            } else {
                listParams = this.getIntersectRangeParameters().get(listId);
                if (listParams == null) {
                    listParams = Arrays.asList(null, null);
                    this.getIntersectRangeParameters().put(listId, listParams);
                }
            }
        } else if (this.union) {
            listParams = this.getUnionParameters().get(listId);
            if (listParams == null) {
                listParams = new ArrayList<Object>(size);
                this.getUnionParameters().put(listId, listParams);
            }
        } else {
            listParams = this.getIntersectParameters().get(listId);
            if (listParams == null) {
                listParams = new ArrayList<Object>(size);
                this.getIntersectParameters().put(listId, listParams);
            }
        }
        return listParams;
    }

    public void setToUnion() {
        this.union = true;
    }

    public void setToIntersection() {
        this.union = false;
    }

    public boolean isUnion() {
        return this.union;
    }

    public void setToLike() {
        this.like = true;
    }

    public boolean isLike() {
        return this.like;
    }

    public void setToEquals() {
        this.like = false;
    }

    public void setToRange() {
        this.range = true;
    }

    public void setToPrecise() {
        this.range = false;
    }

    public boolean isRange() {
        return this.range;
    }

    public void clear() {
        Map[] maps;
        this.union = true;
        this.like = false;
        this.range = false;
        for (Map paramMap : maps = new Map[]{this.unionParameters, this.intersectParameters, this.unionRegexParameters, this.intersectRegexParameters, this.unionRangeParameters, this.intersectRangeParameters}) {
            if (paramMap == null) continue;
            paramMap.clear();
        }
    }

    public QueryParameters(QueryParameters queryParameters) {
        this.union = queryParameters.union;
        this.like = queryParameters.like;
        this.range = queryParameters.range;
        this.intersectParameters = queryParameters.intersectParameters == null ? null : new HashMap<String, List<? extends Object>>(queryParameters.intersectParameters);
        this.unionParameters = queryParameters.unionParameters == null ? null : new HashMap<String, List<? extends Object>>(queryParameters.unionParameters);
        this.intersectRangeParameters = queryParameters.intersectRangeParameters == null ? null : new HashMap<String, List<? extends Object>>(queryParameters.intersectRangeParameters);
        this.unionRangeParameters = queryParameters.unionRangeParameters == null ? null : new HashMap<String, List<? extends Object>>(queryParameters.unionRangeParameters);
        this.intersectRegexParameters = queryParameters.intersectRegexParameters == null ? null : new HashMap<String, List<String>>(queryParameters.intersectRegexParameters);
        this.unionRegexParameters = queryParameters.unionRegexParameters == null ? null : new HashMap<String, List<String>>(queryParameters.unionRegexParameters);
    }
}

