/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.persistence.SocialFile;
import org.kie.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.kie.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialTimelinePersistenceAPI;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public abstract class SocialTimelineCachePersistence
implements SocialTimelinePersistenceAPI {
    public static final String SOCIAL_FILES = "social-files";
    Map<SocialEventType, List<SocialActivitiesEvent>> typeEventsTimelineCache = new HashMap<SocialEventType, List<SocialActivitiesEvent>>();
    Map<SocialEventType, List<SocialActivitiesEvent>> typeEventsFreshEvents = new HashMap<SocialEventType, List<SocialActivitiesEvent>>();
    Map<SocialEventType, SocialCacheControl> typeEventsCacheControl = new HashMap<SocialEventType, SocialCacheControl>();
    int threshold;
    public static final String THRESHOLD_PROPERTY = "org.uberfire.social.threshold";
    private static final int DEFAULT_THRESHOLD = 100;
    IOService ioService;
    Gson gson;
    Type gsonCollectionType;
    SocialEventTypeRepositoryAPI socialEventTypeRepository;
    SocialUserPersistenceAPI socialUserPersistenceAPI;
    SocialUserServicesExtendedBackEndImpl userServicesBackend;
    Map<String, List<SocialActivitiesEvent>> userEventsTimelineCache = new HashMap<String, List<SocialActivitiesEvent>>();
    Map<String, List<SocialActivitiesEvent>> userEventsTimelineFreshEvents = new HashMap<String, List<SocialActivitiesEvent>>();
    Map<String, SocialCacheControl> userEventsCacheControl = new HashMap<String, SocialCacheControl>();

    public void setup() {
        this.createCacheStructure();
        this.createCacheControl();
    }

    private void createCacheControl() {
        for (SocialEventType type : this.socialEventTypeRepository.findAll()) {
            this.typeEventsCacheControl.put(type, new SocialCacheControl());
        }
        for (String username : this.socialUserPersistenceAPI.getSocialUsersName()) {
            this.userEventsCacheControl.put(username, new SocialCacheControl());
        }
    }

    private void createCacheStructure() {
        List<SocialActivitiesEvent> events;
        for (SocialEventType type : this.socialEventTypeRepository.findAll()) {
            events = this.createOrGetTypeTimeline(type);
            this.typeEventsTimelineCache.put(type, events);
            this.typeEventsFreshEvents.put(type, new ArrayList());
        }
        for (String username : this.socialUserPersistenceAPI.getSocialUsersName()) {
            events = this.createOrGetUserTimeline(username);
            this.userEventsTimelineCache.put(username, events);
            this.userEventsTimelineFreshEvents.put(username, new ArrayList());
        }
    }

    List<SocialActivitiesEvent> createOrGetTimeline(Path timelineDir) {
        List<SocialActivitiesEvent> events = new ArrayList<SocialActivitiesEvent>();
        try {
            if (this.getIoService().exists(timelineDir)) {
                Integer lastFileIndex = this.getLastFileIndex(timelineDir);
                if (this.thereIsSomethingToRead(lastFileIndex)) {
                    events = this.getTimeline(timelineDir, lastFileIndex.toString());
                }
            } else {
                this.createPersistenceStructure(timelineDir);
            }
            return events;
        }
        catch (Exception e) {
            throw new ErrorAccessingTimeline(e);
        }
    }

    private List<SocialActivitiesEvent> getTimeline(Path timelineDir, String fileIndex) {
        Path fileTimeline = timelineDir.resolve(fileIndex);
        String numberOfEvents = this.getItemsMetadata(timelineDir, fileIndex);
        SocialFile socialFile = new SocialFile(fileTimeline, this.ioService, this.gson);
        List<SocialActivitiesEvent> events = socialFile.readSocialEvents(Integer.valueOf(numberOfEvents));
        return events;
    }

    private boolean thereIsSomethingToRead(Integer lastFileIndex) {
        return lastFileIndex >= 0;
    }

    Integer getLastFileIndex(Path timelineDir) {
        Path resolve = timelineDir.resolve(Constants.LAST_FILE_INDEX.name());
        if (!this.getIoService().exists(resolve)) {
            return -1;
        }
        String index = this.getIoService().readAllString(resolve);
        Integer lastIndex = Integer.valueOf(index);
        return lastIndex;
    }

    private void createPersistenceStructure(Path timelineDir) {
        String lastIndex = "-1";
        this.updateLastIndexFile(timelineDir, lastIndex);
    }

    private void updateLastIndexFile(Path directory, String lastIndex) {
        Path lastFileIndex = directory.resolve(Constants.LAST_FILE_INDEX.name());
        this.getIoService().write(lastFileIndex, lastIndex, new OpenOption[0]);
    }

    private String persistEvents(List<SocialActivitiesEvent> newEvents, Path timeLineDir) {
        Integer lastFileIndex = this.getLastFileIndex(timeLineDir);
        lastFileIndex = lastFileIndex + 1;
        Path timelineFile = timeLineDir.resolve(lastFileIndex.toString());
        this.writeItems(timelineFile, newEvents);
        this.writeItemsMetadata(timeLineDir, lastFileIndex.toString(), newEvents.size());
        this.updateLastIndexFile(timeLineDir, lastFileIndex.toString());
        return lastFileIndex.toString();
    }

    private void writeItemsMetadata(Path timeLineDir, String originalFilename, int size) {
        String metadataFileName = originalFilename + (Object)((Object)Constants.METADATA);
        Path timelineFile = timeLineDir.resolve(metadataFileName);
        this.ioService.write(timelineFile, size + "", new OpenOption[0]);
    }

    private String getItemsMetadata(Path timeLineDir, String originalFilename) {
        String metadataFileName = originalFilename + (Object)((Object)Constants.METADATA);
        Path timelineFile = timeLineDir.resolve(metadataFileName);
        if (this.ioService.exists(timelineFile)) {
            String itemsMetadata = this.ioService.readAllString(timelineFile);
            return itemsMetadata;
        }
        return "-1";
    }

    private void writeItems(Path timeLineFile, List<SocialActivitiesEvent> newEvents) {
        SocialFile socialFile = new SocialFile(timeLineFile, this.ioService, this.gson);
        try {
            socialFile.write(newEvents);
        }
        catch (IOException e) {
            throw new ErrorAccessingTimeline(e);
        }
    }

    IOService getIoService() {
        return this.ioService;
    }

    int getThreshold() {
        if (this.threshold == 0) {
            String property = System.getProperty(THRESHOLD_PROPERTY);
            this.threshold = property != null && !property.isEmpty() ? Integer.valueOf(property) : 100;
        }
        return this.threshold;
    }

    List<SocialActivitiesEvent> createOrGetTypeTimeline(SocialEventType type) {
        Path timelineDir = this.userServicesBackend.buildPath(SOCIAL_FILES, type.name());
        return this.createOrGetTimeline(timelineDir);
    }

    public List<SocialActivitiesEvent> getLastEvents(SocialEventType key) {
        ArrayList<SocialActivitiesEvent> socialActivitiesEvents = new ArrayList<SocialActivitiesEvent>();
        socialActivitiesEvents.addAll((Collection)this.typeEventsTimelineCache.get(key));
        socialActivitiesEvents.addAll((Collection)this.typeEventsFreshEvents.get(key));
        return socialActivitiesEvents;
    }

    List<SocialActivitiesEvent> storeTimeLineInFile(SocialEventType type) {
        List<SocialActivitiesEvent> socialActivitiesEvents = this.typeEventsFreshEvents.get(type);
        this.persistEvents(type, socialActivitiesEvents);
        this.refreshCache(type, socialActivitiesEvents);
        return socialActivitiesEvents;
    }

    void refreshCache(SocialEventType type, List<SocialActivitiesEvent> socialActivitiesEvents) {
        this.typeEventsFreshEvents.put(type, new ArrayList());
        this.typeEventsTimelineCache.put(type, socialActivitiesEvents);
    }

    private void persistEvents(SocialEventType type, List<SocialActivitiesEvent> newEvents) {
        Path timeLineDir = this.userServicesBackend.buildPath(SOCIAL_FILES, type.name());
        this.persistEvents(newEvents, timeLineDir);
    }

    public Integer numberOfPages(SocialEventType type) {
        Path timelineDir = this.userServicesBackend.buildPath(SOCIAL_FILES, type.name());
        Integer lastFileIndex = this.getLastFileIndex(timelineDir);
        return lastFileIndex;
    }

    public List<SocialActivitiesEvent> getRecentEvents(SocialEventType type) {
        ArrayList<SocialActivitiesEvent> socialActivitiesEvents = new ArrayList<SocialActivitiesEvent>();
        List<SocialActivitiesEvent> typeEvents = this.typeEventsFreshEvents.get(type);
        if (typeEvents != null) {
            socialActivitiesEvents.addAll(typeEvents);
        }
        return socialActivitiesEvents;
    }

    public Integer getTypeMostRecentFileIndex(SocialEventType type) {
        Path timelineDir = this.userServicesBackend.buildPath(SOCIAL_FILES, type.name());
        Integer lastFileIndex = this.getLastFileIndex(timelineDir);
        return lastFileIndex;
    }

    public List<SocialActivitiesEvent> getTimeline(SocialEventType type, String timelineFile) {
        Path timelineDir = this.userServicesBackend.buildPath(SOCIAL_FILES, type.name());
        List<SocialActivitiesEvent> timeline = this.getTimeline(timelineDir, timelineFile);
        return timeline;
    }

    List<SocialActivitiesEvent> createOrGetUserTimeline(String userName) {
        Path timelineDir = this.getRootUserTimelineDirectory();
        Path userFile = timelineDir.resolve(userName);
        return this.createOrGetTimeline(userFile);
    }

    private String persistEvents(SocialUser user, List<SocialActivitiesEvent> newEvents) {
        Path userDir = this.getUserDirectory(user.getUserName());
        if (!this.ioService.exists(userDir)) {
            this.createPersistenceStructure(userDir);
        }
        String fileName = this.persistEvents(newEvents, userDir);
        return fileName;
    }

    private Path getUserDirectory(String userName) {
        Path directory = this.getRootUserTimelineDirectory();
        return directory.resolve(userName);
    }

    public List<SocialActivitiesEvent> getLastEvents(SocialUser user) {
        ArrayList<SocialActivitiesEvent> socialActivitiesEvents = new ArrayList<SocialActivitiesEvent>();
        List<SocialActivitiesEvent> userEvents = this.userEventsTimelineCache.get(user.getUserName());
        if (userEvents == null) {
            this.createCacheStructureForNewUsers(user);
        }
        socialActivitiesEvents.addAll((Collection)this.userEventsTimelineCache.get(user.getUserName()));
        socialActivitiesEvents.addAll((Collection)this.userEventsTimelineFreshEvents.get(user.getUserName()));
        return socialActivitiesEvents;
    }

    public List<SocialActivitiesEvent> getRecentEvents(SocialUser user) {
        ArrayList<SocialActivitiesEvent> socialActivitiesEvents = new ArrayList<SocialActivitiesEvent>();
        List<SocialActivitiesEvent> userEvents = this.userEventsTimelineFreshEvents.get(user.getUserName());
        if (userEvents == null) {
            this.createCacheStructureForNewUsers(user);
        }
        socialActivitiesEvents.addAll((Collection)this.userEventsTimelineFreshEvents.get(user.getUserName()));
        return socialActivitiesEvents;
    }

    private void createCacheStructureForNewUsers(SocialUser user) {
        this.userEventsTimelineCache.put(user.getUserName(), new ArrayList());
        this.userEventsTimelineFreshEvents.put(user.getUserName(), new ArrayList());
    }

    List<SocialActivitiesEvent> storeTimeLineInFile(SocialUser user) {
        List<SocialActivitiesEvent> socialActivitiesEvents = this.userEventsTimelineFreshEvents.get(user.getUserName());
        this.persistEvents(user, socialActivitiesEvents);
        this.refreshCache(user, socialActivitiesEvents);
        return socialActivitiesEvents;
    }

    void refreshCache(SocialUser user, List<SocialActivitiesEvent> socialActivitiesEvents) {
        this.userEventsTimelineFreshEvents.put(user.getUserName(), new ArrayList());
        this.userEventsTimelineCache.put(user.getUserName(), socialActivitiesEvents);
    }

    Path getRootUserTimelineDirectory() {
        Path path = this.userServicesBackend.buildPath(SOCIAL_FILES, Constants.USER_TIMELINE.name());
        return path;
    }

    public Integer getUserMostRecentFileIndex(SocialUser user) {
        Path timelineDir = this.getUserDirectory(user.getUserName());
        Integer lastFileIndex = this.getLastFileIndex(timelineDir);
        return lastFileIndex;
    }

    public List<SocialActivitiesEvent> getTimeline(SocialUser socialUser, String timelineFile) {
        Path userDirectory = this.getUserDirectory(socialUser.getUserName());
        List<SocialActivitiesEvent> timeline = this.getTimeline(userDirectory, timelineFile);
        return timeline;
    }

    void saveAllUserTimelines() {
        for (String userName : this.userEventsTimelineFreshEvents.keySet()) {
            List<SocialActivitiesEvent> socialActivitiesEvents = this.userEventsTimelineFreshEvents.get(userName);
            if (socialActivitiesEvents.isEmpty()) continue;
            SocialUser socialUser = this.socialUserPersistenceAPI.getSocialUser(userName);
            this.storeTimeLineInFile(socialUser);
        }
    }

    void saveAllTypeEvents() {
        for (SocialEventType socialEventType : this.typeEventsFreshEvents.keySet()) {
            List<SocialActivitiesEvent> socialActivitiesEvents = this.typeEventsFreshEvents.get(socialEventType);
            if (socialActivitiesEvents.isEmpty()) continue;
            this.storeTimeLineInFile(socialEventType);
        }
    }

    public Integer getNumberOfEventsOnFile(SocialEventType type, String originalFilename) {
        Path typedir = this.userServicesBackend.buildPath(SOCIAL_FILES, type.name());
        return this.getNumberOfEventsOnPath(originalFilename, typedir);
    }

    Integer getNumberOfEventsOnPath(String originalFilename, Path path) {
        String itemsMetadata = this.getItemsMetadata(path, originalFilename);
        try {
            return Integer.parseInt(itemsMetadata);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Integer getNumberOfEventsOnFile(SocialUser socialUser, String originalFilename) {
        Path userDirectory = this.getUserDirectory(socialUser.getUserName());
        return this.getNumberOfEventsOnPath(originalFilename, userDirectory);
    }

    static enum Constants {
        LAST_FILE_INDEX,
        USER_TIMELINE,
        METADATA;

    }

    private class ErrorAccessingTimeline
    extends RuntimeException {
        public ErrorAccessingTimeline(Exception e) {
            e.printStackTrace();
        }
    }

    protected class SocialCacheControl {
        private int sizeOfcache;

        public SocialCacheControl() {
            this.reset();
        }

        public void registerNewEvent() {
            ++this.sizeOfcache;
        }

        public boolean needToPersist() {
            return this.sizeOfcache > SocialTimelineCachePersistence.this.getThreshold();
        }

        public void reset() {
            this.sizeOfcache = 0;
        }
    }
}

