/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public abstract class SocialUserCachePersistence
implements SocialUserPersistenceAPI {
    private static final String userNamesFileName = "userNames";
    public static final String SOCIAL_FILES = "social-files";
    SocialUserServicesExtendedBackEndImpl userServicesBackend;
    private final UserServicesImpl userServices;
    IOService ioService;
    private static final String SYSTEM_USER = "system";
    private Path userNamesPath;
    Gson gson;
    Map<String, SocialUser> usersCache = new HashMap<String, SocialUser>();
    List<String> usersNamesCache = new ArrayList<String>();

    public SocialUserCachePersistence(SocialUserServicesExtendedBackEndImpl userServicesBackend, UserServicesImpl userServices, IOService ioService, Gson gson) {
        this.userServicesBackend = userServicesBackend;
        this.userServices = userServices;
        this.ioService = ioService;
        this.gson = gson;
        this.userNamesPath = userServicesBackend.buildPath(SOCIAL_FILES, userNamesFileName);
        this.syncSocialUsers();
    }

    private void syncSocialUsers() {
        List<String> users = this.createUserNamesFile();
        this.usersNamesCache.addAll(users);
        this.createSocialUserCache(users);
    }

    public List<String> getSocialUsersName() {
        return this.usersNamesCache;
    }

    public synchronized SocialUser getSocialUser(String userName) {
        this.syncUserNamesCacheAndFile(userName);
        return this.usersCache.get(userName);
    }

    abstract String syncUserNamesCacheAndFile(String var1);

    SocialUser createOrRetrieveUserData(String username) throws RuntimeException {
        try {
            Path userFile = this.userServicesBackend.buildPath(SOCIAL_FILES, username);
            if (this.ioService.exists(userFile)) {
                String json = this.ioService.readAllString(userFile);
                SocialUser socialUser = (SocialUser)this.gson.fromJson(json, SocialUser.class);
                return socialUser;
            }
            SocialUser newSocialUser = new SocialUser(username);
            String json = this.gson.toJson((Object)newSocialUser);
            this.ioService.write(userFile, json, new OpenOption[0]);
            return newSocialUser;
        }
        catch (Exception e) {
            throw new ErrorCreatingOrRetrievingUserData(e);
        }
    }

    public abstract void updateUsers(SocialUser ... var1);

    void writeUserNamesOnFile(List<String> userNames) {
        String json = this.gson.toJson(userNames);
        this.ioService.write(this.userNamesPath, json, new OpenOption[0]);
    }

    private void createSocialUserCache(List<String> users) {
        for (String username : users) {
            SocialUser socialUser = this.createOrRetrieveUserData(username);
            this.usersCache.put(username, socialUser);
        }
    }

    List<String> createUserNamesFile() {
        List<String> users = this.extractUsersFromBranches();
        this.createUserNameFiles();
        this.persistUsersName(users);
        return users;
    }

    private void createUserNameFiles() {
        if (!this.ioService.exists(this.userNamesPath)) {
            this.createFile();
        }
    }

    private void persistUsersName(List<String> users) {
        this.writeUserNamesOnFile(users);
    }

    private void createFile() {
        this.ioService.createFile(this.userNamesPath, new FileAttribute[0]);
    }

    private List<String> extractUsersFromBranches() {
        ArrayList<String> userNames = new ArrayList<String>();
        for (String branchName : this.getAllBranches()) {
            String cleanName;
            if (!this.isAValidBranch(branchName) || !this.notAMergedBranch(cleanName = this.retrieveUserFrom(branchName))) continue;
            userNames.add(cleanName);
        }
        this.createSystemUser(userNames);
        return userNames;
    }

    private List<String> getAllBranches() {
        return this.userServicesBackend.getAllBranches();
    }

    private boolean notAMergedBranch(String cleanName) {
        return !cleanName.contains("upstream") && !cleanName.contains("@");
    }

    private void createSystemUser(List<String> userNames) {
        userNames.add(SYSTEM_USER);
    }

    private boolean isAValidBranch(String branchName) {
        return !branchName.contains("master");
    }

    private String retrieveUserFrom(String branchName) {
        String user = branchName;
        if (branchName.indexOf("-") > 0) {
            user = branchName.substring(0, branchName.indexOf("-"));
        }
        return user;
    }

    public SocialUser systemUser() {
        return this.getSocialUser(SYSTEM_USER);
    }

    class ErrorUpdatingUsers
    extends RuntimeException {
        public ErrorUpdatingUsers(Exception e) {
            e.printStackTrace();
        }
    }

    public class ErrorCreatingOrRetrievingUserData
    extends RuntimeException {
        public ErrorCreatingOrRetrievingUserData(Exception e) {
            e.printStackTrace();
        }
    }
}

