/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_1.extensions.MyTestRegister;
import org.kie.dmn.backend.marshalling.v1_1.xstream.extensions.DecisionServicesExtensionRegister;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.model.api.Definitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class UnmarshalMarshalTest {
    protected static final Logger LOG = LoggerFactory.getLogger(UnmarshalMarshalTest.class);

    @Test
    public void test0001() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0001-input-data-string.dmn");
    }

    @Test
    public void test0002() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0002-input-data-number.dmn");
    }

    @Test
    public void test0003() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0003-input-data-string-allowed-values.dmn");
    }

    @Test
    public void test0004() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new DecisionServicesExtensionRegister()));
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0004-decision-services.dmn", marshaller);
    }

    @Test
    public void test0004_ns_other_location() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new DecisionServicesExtensionRegister()));
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0004-decision-services_ns_other_location.dmn", marshaller);
    }

    @Test
    public void test0005_decision_list() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0005-decision-list.dmn");
    }

    @Test
    public void test_hardcoded_java_max_call() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "hardcoded-java-max-call.dmn");
    }

    @Test
    public void testDish() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "dish-decision.xml");
    }

    @Ignore(value="failing to compare over a xsi:type=\"tImport\" attribute, but why content generated 'control' need to explicit it ?")
    @Test
    public void testDummyDefinitions() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "dummy-definitions.xml");
    }

    @Test
    public void testDummyRelation() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "dummy-relation.xml");
    }

    @Test
    public void testCh11() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "ch11example.xml");
    }

    @Test
    public void testHello_World_semantic_namespace() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "Hello_World_semantic_namespace.dmn");
    }

    @Test
    public void testHello_World_semantic_namespace_with_extensions() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new MyTestRegister()));
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "Hello_World_semantic_namespace_with_extensions.dmn", marshaller);
    }

    @Test
    public void testHello_World_semantic_namespace_with_extensions_other_ns_location() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new MyTestRegister()));
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "Hello_World_semantic_namespace_with_extensions_other_ns_location.dmn", marshaller);
    }

    @Test
    public void testSemanticNamespace() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "semantic-namespace.xml");
    }

    @Ignore(value="The current file cannot marshal back extension elements because they don't provide converters.")
    @Test
    public void test20161014() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "test20161014.xml");
    }

    @Test
    public void testQNameSerialization() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "hardcoded_function_definition.dmn");
    }

    @Ignore(value="A problem with the StaxDriver has still to be resolved.")
    @Test
    public void testFAILforMissingNamespaces() {
        Assert.fail((String)"PERFORM A MANUAL CHECK: does now the Stax driver do output the namespace for 'feel:' ?? ");
    }

    public void testRoundTrip(String subdir, String xmlfile) throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newDefaultMarshaller();
        this.testRoundTrip(subdir, xmlfile, marshaller);
    }

    public void testRoundTrip(String subdir, String xmlfile, DMNMarshaller marshaller) throws Exception {
        File baseOutputDir = new File("target/test-xmlunit/");
        File testClassesBaseDir = new File("target/test-classes/");
        File inputXMLFile = new File(testClassesBaseDir, subdir + xmlfile);
        FileInputStream fis = new FileInputStream(inputXMLFile);
        Definitions unmarshal = marshaller.unmarshal((Reader)new InputStreamReader(fis));
        Validator v = Validator.forLanguage((String)"http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(this.getClass().getResource("/DMN11.xsd").getFile()));
        ValidationResult validateInputResult = v.validateInstance((Source)new StreamSource(inputXMLFile));
        if (!validateInputResult.isValid()) {
            for (ValidationProblem p : validateInputResult.getProblems()) {
                LOG.error("{}", (Object)p);
            }
        }
        Assert.assertTrue((boolean)validateInputResult.isValid());
        File subdirFile = new File(baseOutputDir, subdir);
        if (!subdirFile.mkdirs()) {
            LOG.warn("mkdirs() failed for File: {}", (Object)subdirFile.getAbsolutePath());
        }
        FileOutputStream sourceFos = new FileOutputStream(new File(baseOutputDir, subdir + "a." + xmlfile));
        Files.copy(new File(testClassesBaseDir, subdir + xmlfile).toPath(), sourceFos);
        sourceFos.flush();
        sourceFos.close();
        LOG.debug("{}", (Object)marshaller.marshal((Object)unmarshal));
        File outputXMLFile = new File(baseOutputDir, subdir + "b." + xmlfile);
        try (FileWriter targetFos = new FileWriter(outputXMLFile);){
            marshaller.marshal((Object)unmarshal, (Writer)targetFos);
        }
        ValidationResult validateOutputResult = v.validateInstance((Source)new StreamSource(outputXMLFile));
        if (!validateOutputResult.isValid()) {
            for (ValidationProblem p : validateOutputResult.getProblems()) {
                LOG.error("{}", (Object)p);
            }
        }
        Assert.assertTrue((boolean)validateOutputResult.isValid());
        LOG.debug("\n---\nDefault XMLUnit comparison:");
        Source control = Input.fromFile((File)inputXMLFile).build();
        Source test = Input.fromFile((File)outputXMLFile).build();
        Diff allDiffsSimilarAndDifferent = DiffBuilder.compare((Object)control).withTest((Object)test).build();
        allDiffsSimilarAndDifferent.getDifferences().forEach(m -> LOG.debug("{}", m));
        LOG.info("XMLUnit comparison with customized similarity for defaults:");
        HashSet<QName> attrWhichCanDefault = new HashSet<QName>();
        attrWhichCanDefault.addAll(Arrays.asList(new QName("expressionLanguage"), new QName("typeLanguage"), new QName("isCollection"), new QName("hitPolicy"), new QName("preferredOrientation")));
        HashSet<String> nodeHavingDefaultableAttr = new HashSet<String>();
        nodeHavingDefaultableAttr.addAll(Arrays.asList("definitions", "decisionTable", "itemDefinition", "itemComponent"));
        Diff checkSimilar = DiffBuilder.compare((Object)control).withTest((Object)test).withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, (comparison, outcome) -> {
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && nodeHavingDefaultableAttr.contains(this.safeStripDMNPRefix(comparison.getControlDetails().getTarget()))) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_NAME_LOOKUP) {
                boolean testIsDefaulableAttribute = false;
                QName whichDefaultableAttr = null;
                if (comparison.getControlDetails().getValue() == null && attrWhichCanDefault.contains(comparison.getTestDetails().getValue())) {
                    for (QName a : attrWhichCanDefault) {
                        boolean check = comparison.getTestDetails().getXPath().endsWith("@" + a);
                        if (!check) continue;
                        testIsDefaulableAttribute = true;
                        whichDefaultableAttr = a;
                    }
                }
                if (testIsDefaulableAttribute && comparison.getTestDetails().getXPath().equals(comparison.getControlDetails().getXPath() + "/@" + whichDefaultableAttr)) {
                    return ComparisonResult.SIMILAR;
                }
            }
            return outcome;
        }})).ignoreWhitespace().checkForSimilar().build();
        checkSimilar.getDifferences().forEach(m -> LOG.error("{}", m));
        if (!checkSimilar.getDifferences().iterator().hasNext()) {
            LOG.info("[ EMPTY - no diffs using customized similarity ]");
        }
        Assert.assertFalse((String)("XML are NOT similar: " + checkSimilar.toString()), (boolean)checkSimilar.hasDifferences());
    }

    private String safeStripDMNPRefix(Node target) {
        if ("http://www.omg.org/spec/DMN/20151101/dmn.xsd".equals(target.getNamespaceURI())) {
            return target.getLocalName();
        }
        return null;
    }
}

