/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_4;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_3.extensions.TrisoExtensionRegister;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.backend.marshalling.v1x.XStreamMarshaller;
import org.kie.dmn.model.api.Definitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class UnmarshalMarshalTest {
    private static final StreamSource DMN14_SCHEMA_SOURCE = new StreamSource(UnmarshalMarshalTest.class.getResource("/DMN14.xsd").getFile());
    private static final DMNMarshaller MARSHALLER = new XStreamMarshaller();
    protected static final Logger LOG = LoggerFactory.getLogger(UnmarshalMarshalTest.class);

    @Test
    public void testV14_simple() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "simple.dmn");
    }

    @Test
    public void testV14_ch11example_asFromOMG() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new TrisoExtensionRegister()));
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_4/", "Chapter 11 Example.dmn", marshaller, DMN14_SCHEMA_SOURCE);
    }

    @Test
    public void testV14_financial() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "Financial.dmn");
    }

    @Test
    public void testV14_loan_info() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "Loan info.dmn");
    }

    @Test
    public void testV14_recommended_loan_product() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "Recommended Loan Products.dmn");
    }

    @Test
    public void testV14_for() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "sampleFor.dmn");
    }

    @Test
    public void testV14_quantified() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "sampleQuantified.dmn");
    }

    @Test
    public void testV14_conditional() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "sampleConditional.dmn");
    }

    @Test
    public void testV14_filter() throws Exception {
        this.testRoundTripV14("org/kie/dmn/backend/marshalling/v1_4/", "sampleFilter.dmn");
    }

    public void testRoundTripV14(String subdir, String xmlfile) throws Exception {
        this.testRoundTrip(subdir, xmlfile, MARSHALLER, DMN14_SCHEMA_SOURCE);
    }

    public void testRoundTrip(String subdir, String xmlfile, DMNMarshaller marshaller, Source schemaSource) throws Exception {
        File baseOutputDir = new File("target/test-xmlunit/");
        File testClassesBaseDir = new File("target/test-classes/");
        File inputXMLFile = new File(testClassesBaseDir, subdir + xmlfile);
        FileInputStream fis = new FileInputStream(inputXMLFile);
        Definitions unmarshal = marshaller.unmarshal((Reader)new InputStreamReader(fis));
        Validator v = Validator.forLanguage((String)"http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource(schemaSource);
        ValidationResult validateInputResult = v.validateInstance((Source)new StreamSource(inputXMLFile));
        if (!validateInputResult.isValid()) {
            for (ValidationProblem p : validateInputResult.getProblems()) {
                LOG.error("{}", (Object)p);
            }
        }
        Assertions.assertThat((boolean)validateInputResult.isValid()).isTrue();
        File subdirFile = new File(baseOutputDir, subdir);
        if (!subdirFile.mkdirs()) {
            LOG.warn("mkdirs() failed for File: ", (Object)subdirFile.getAbsolutePath());
        }
        FileOutputStream sourceFos = new FileOutputStream(new File(baseOutputDir, subdir + "a." + xmlfile));
        Files.copy(new File(testClassesBaseDir, subdir + xmlfile).toPath(), sourceFos);
        sourceFos.flush();
        sourceFos.close();
        LOG.debug("{}", (Object)marshaller.marshal((Object)unmarshal));
        File outputXMLFile = new File(baseOutputDir, subdir + "b." + xmlfile);
        try (FileWriter targetFos = new FileWriter(outputXMLFile);){
            marshaller.marshal((Object)unmarshal, (Writer)targetFos);
        }
        ValidationResult validateOutputResult = v.validateInstance((Source)new StreamSource(outputXMLFile));
        if (!validateOutputResult.isValid()) {
            for (ValidationProblem p : validateOutputResult.getProblems()) {
                LOG.error("{}", (Object)p);
            }
        }
        Assertions.assertThat((boolean)validateOutputResult.isValid()).isTrue();
        LOG.debug("\n---\nDefault XMLUnit comparison:");
        Source control = Input.fromFile((File)inputXMLFile).build();
        Source test = Input.fromFile((File)outputXMLFile).build();
        Diff allDiffsSimilarAndDifferent = DiffBuilder.compare((Object)control).withTest((Object)test).build();
        allDiffsSimilarAndDifferent.getDifferences().forEach(m -> LOG.debug("{}", m));
        LOG.info("XMLUnit comparison with customized similarity for defaults:");
        HashSet<QName> attrWhichCanDefault = new HashSet<QName>();
        attrWhichCanDefault.addAll(Arrays.asList(new QName("expressionLanguage"), new QName("typeLanguage"), new QName("isCollection"), new QName("hitPolicy"), new QName("preferredOrientation"), new QName("kind"), new QName("textFormat"), new QName("associationDirection"), new QName("isCollapsed")));
        HashSet<String> nodeHavingDefaultableAttr = new HashSet<String>();
        nodeHavingDefaultableAttr.addAll(Arrays.asList("definitions", "decisionTable", "itemDefinition", "itemComponent", "encapsulatedLogic", "textAnnotation", "association", "DMNShape"));
        Diff checkSimilar = DiffBuilder.compare((Object)control).withTest((Object)test).withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, (comparison, outcome) -> {
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && nodeHavingDefaultableAttr.contains(this.safeStripDMNPRefix(comparison.getControlDetails().getTarget()))) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_VALUE && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && comparison.getControlDetails().getTarget().getNodeType() == 2 && comparison.getControlDetails().getTarget().getLocalName().equals("documentation")) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_NAME_LOOKUP) {
                boolean testIsDefaulableAttribute = false;
                QName whichDefaultableAttr = null;
                if (comparison.getControlDetails().getValue() == null && attrWhichCanDefault.contains(comparison.getTestDetails().getValue())) {
                    for (QName a : attrWhichCanDefault) {
                        boolean check = comparison.getTestDetails().getXPath().endsWith("@" + a);
                        if (!check) continue;
                        testIsDefaulableAttribute = true;
                        whichDefaultableAttr = a;
                    }
                }
                if (testIsDefaulableAttribute && comparison.getTestDetails().getXPath().equals(comparison.getControlDetails().getXPath() + "/@" + whichDefaultableAttr)) {
                    return ComparisonResult.SIMILAR;
                }
            }
            return outcome;
        }})).ignoreWhitespace().checkForSimilar().build();
        checkSimilar.getDifferences().forEach(m -> LOG.error("{}", m));
        if (!checkSimilar.getDifferences().iterator().hasNext()) {
            LOG.info("[ EMPTY - no diffs using customized similarity ]");
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)checkSimilar.hasDifferences()).as("XML are NOT similar: " + checkSimilar.toString(), new Object[0])).isFalse();
    }

    private String safeStripDMNPRefix(Node target) {
        if ("https://www.omg.org/spec/DMN/20211108/MODEL/".equals(target.getNamespaceURI()) || "https://www.omg.org/spec/DMN/20191111/DMNDI/".equals(target.getNamespaceURI())) {
            return target.getLocalName();
        }
        return null;
    }
}

