/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.gwt.functions.api;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.gwt.functions.api.FunctionDefinitionStrings;
import org.kie.dmn.feel.gwt.functions.api.FunctionOverrideVariation;
import org.kie.dmn.feel.gwt.functions.api.Parameter;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class FunctionOverrideVariationTest {
    private FunctionOverrideVariation functionOverrideVariation;

    @Before
    public void setup() {
        Parameter input = new Parameter("input", BuiltInType.STRING);
        Parameter pattern = new Parameter("pattern", BuiltInType.STRING);
        Parameter replacement = new Parameter("replacement", BuiltInType.STRING);
        Parameter flags = new Parameter("flags", BuiltInType.STRING);
        this.functionOverrideVariation = new FunctionOverrideVariation((Type)BuiltInType.STRING, "replace", new Parameter[]{input, pattern, replacement, flags});
    }

    @Test
    public void testToHumanReadableString() {
        Assertions.assertThat((String)this.functionOverrideVariation.toHumanReadableString()).isEqualTo("string, string, string, string");
    }

    @Test
    public void testToHumanReadableStrings() {
        FunctionDefinitionStrings functionDefinitionStrings = this.functionOverrideVariation.toHumanReadableStrings();
        Assertions.assertThat((String)functionDefinitionStrings.getHumanReadable()).isEqualTo("replace(string, string, string, string)");
        Assertions.assertThat((String)functionDefinitionStrings.getTemplate()).isEqualTo("replace($1, $2, $3, $4)");
    }
}

