/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.gwt.functions.rebind;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.feel.gwt.functions.rebind.FileCreator;
import org.kie.dmn.feel.gwt.functions.rebind.FunctionProviderGenerator;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FunctionProviderGeneratorTest {
    @Mock
    private TreeLogger logger;
    @Mock
    private GeneratorContext context;
    @Mock
    private TypeOracle typeOracle;
    @Mock
    private FileCreator fileCreator;
    private FunctionProviderGenerator generator;

    @Before
    public void setup() {
        this.generator = (FunctionProviderGenerator)Mockito.spy((Object)new FunctionProviderGenerator());
        Mockito.when((Object)this.context.getTypeOracle()).thenReturn((Object)this.typeOracle);
    }

    @Test
    public void testGenerate() {
        String requestedClass = "requestedClass";
        String expectedGenerate = "org.kie.dmn.feel.gwt.functions.client.FEELFunctionProviderImpl";
        ((FunctionProviderGenerator)Mockito.doReturn((Object)this.fileCreator).when((Object)this.generator)).getFileCreator(this.logger, this.context);
        ((FunctionProviderGenerator)Mockito.doNothing().when((Object)this.generator)).assertFEELFunctionProviderClass((JClassType)ArgumentMatchers.any());
        String actualGenerate = this.generator.generate(this.logger, this.context, "requestedClass");
        ((FileCreator)Mockito.verify((Object)this.fileCreator)).write();
        Assertions.assertThat((String)actualGenerate).isEqualTo("org.kie.dmn.feel.gwt.functions.client.FEELFunctionProviderImpl");
    }

    @Test
    public void testGenerateWhenFunctionProviderClassAssertFails() {
        String requestedClass = "requestedClass";
        ((FunctionProviderGenerator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.generator)).assertFEELFunctionProviderClass((JClassType)ArgumentMatchers.any());
        String actualGenerate = this.generator.generate(this.logger, this.context, "requestedClass");
        ((FileCreator)Mockito.verify((Object)this.fileCreator, (VerificationMode)Mockito.never())).write();
        Assertions.assertThat((String)actualGenerate).isNull();
    }
}

