/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.gwt.functions.rebind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.gwt.functions.rebind.MethodTemplates;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.parser.feel11.profiles.KieExtendedFEELProfile;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.extended.KieExtendedDMNFunctions;

public class MethodTemplatesTest {
    private static final List<FEELProfile> profiles = new ArrayList<FEELProfile>();

    @Test
    public void testTemplate() {
        String template = MethodTemplates.getTemplate();
        String[] templateLines = template.split("\n");
        Assertions.assertThat((String)templateLines[0]).isEqualTo("public List<FunctionOverrideVariation> getDefinitions() {");
        Assertions.assertThat((String)templateLines[1]).isEqualTo("    ArrayList definitions = new ArrayList();");
        this.assertTemplateBody(templateLines);
        Assertions.assertThat((String)templateLines[templateLines.length - 2]).isEqualTo("    return definitions;");
        Assertions.assertThat((String)templateLines[templateLines.length - 1]).isEqualTo("}");
    }

    @Test
    public void testTemplatedFunctionsCanBeEvaluated() {
        FEEL feel = FEEL.newInstance(profiles);
        List templatedFunctions = MethodTemplates.getFeelFunctions();
        Assertions.assertThat((boolean)templatedFunctions.stream().allMatch(fn -> feel.evaluate(fn.getName()) instanceof FEELFunction)).isTrue();
    }

    @Test
    public void testTemplatedFunctionsIncludeBuiltInAndKieExtendedFunctions() {
        List templatedFunctions = MethodTemplates.getFeelFunctions();
        Assertions.assertThat((List)templatedFunctions).containsAll(Arrays.asList(BuiltInFunctions.getFunctions()));
        Assertions.assertThat((List)templatedFunctions).containsAll(Arrays.asList(KieExtendedDMNFunctions.getFunctions()));
    }

    private void assertTemplateBody(String[] templateLines) {
        List<String> lines = Arrays.asList(templateLines);
        this.assertLine(lines, "BuiltInType.DATE, \"date\", new Parameter( \"year\", BuiltInType.NUMBER ), new Parameter( \"month\", BuiltInType.NUMBER ), new Parameter( \"day\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.DATE, \"date\", new Parameter( \"from\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.DATE, \"date\", new Parameter( \"from\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.TIME, \"time\", new Parameter( \"from\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.TIME, \"time\", new Parameter( \"hour\", BuiltInType.NUMBER ), new Parameter( \"minute\", BuiltInType.NUMBER ), new Parameter( \"second\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.TIME, \"time\", new Parameter( \"from\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.TIME, \"time\", new Parameter( \"hour\", BuiltInType.NUMBER ), new Parameter( \"minute\", BuiltInType.NUMBER ), new Parameter( \"second\", BuiltInType.NUMBER ), new Parameter( \"offset\", BuiltInType.DURATION ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date and time\", new Parameter( \"year\", BuiltInType.NUMBER ), new Parameter( \"month\", BuiltInType.NUMBER ), new Parameter( \"day\", BuiltInType.NUMBER ), new Parameter( \"hour\", BuiltInType.NUMBER ), new Parameter( \"minute\", BuiltInType.NUMBER ), new Parameter( \"second\", BuiltInType.NUMBER ), new Parameter( \"hour offset\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date and time\", new Parameter( \"year\", BuiltInType.NUMBER ), new Parameter( \"month\", BuiltInType.NUMBER ), new Parameter( \"day\", BuiltInType.NUMBER ), new Parameter( \"hour\", BuiltInType.NUMBER ), new Parameter( \"minute\", BuiltInType.NUMBER ), new Parameter( \"second\", BuiltInType.NUMBER ), new Parameter( \"timezone\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date and time\", new Parameter( \"date\", BuiltInType.DATE_TIME ), new Parameter( \"time\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date and time\", new Parameter( \"from\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date and time\", new Parameter( \"year\", BuiltInType.NUMBER ), new Parameter( \"month\", BuiltInType.NUMBER ), new Parameter( \"day\", BuiltInType.NUMBER ), new Parameter( \"hour\", BuiltInType.NUMBER ), new Parameter( \"minute\", BuiltInType.NUMBER ), new Parameter( \"second\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.DURATION, \"duration\", new Parameter( \"from\", BuiltInType.DURATION ) )");
        this.assertLine(lines, "BuiltInType.DURATION, \"duration\", new Parameter( \"from\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.DURATION, \"years and months duration\", new Parameter( \"from\", BuiltInType.DATE_TIME ), new Parameter( \"to\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"string\", new Parameter( \"from\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"string\", new Parameter( \"mask\", BuiltInType.STRING ), new Parameter( \"p\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"number\", new Parameter( \"from\", BuiltInType.STRING ), new Parameter( \"grouping separator\", BuiltInType.STRING ), new Parameter( \"decimal separator\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"substring\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"start position\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"substring\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"start position\", BuiltInType.NUMBER ), new Parameter( \"length\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"substring before\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"match\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"substring after\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"match\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"string length\", new Parameter( \"string\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"upper case\", new Parameter( \"string\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"lower case\", new Parameter( \"string\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"contains\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"match\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"starts with\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"match\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"ends with\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"match\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"matches\", new Parameter( \"input\", BuiltInType.STRING ), new Parameter( \"pattern\", BuiltInType.STRING ), new Parameter( \"flags\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"matches\", new Parameter( \"input\", BuiltInType.STRING ), new Parameter( \"pattern\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"replace\", new Parameter( \"input\", BuiltInType.STRING ), new Parameter( \"pattern\", BuiltInType.STRING ), new Parameter( \"replacement\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"replace\", new Parameter( \"input\", BuiltInType.STRING ), new Parameter( \"pattern\", BuiltInType.STRING ), new Parameter( \"replacement\", BuiltInType.STRING ), new Parameter( \"flags\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"list contains\", new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"element\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"count\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"count\", new Parameter( \"c\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"min\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"min\", new Parameter( \"c\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"max\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"max\", new Parameter( \"c\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"sum\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"sum\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"sum\", new Parameter( \"list\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"mean\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"mean\", new Parameter( \"list\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"mean\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"sublist\", new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"start position\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"sublist\", new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"start position\", BuiltInType.NUMBER ), new Parameter( \"length\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"append\", new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"item\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"append\", new Parameter( \"list\", BuiltInType.UNKNOWN ), new Parameter( \"item\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"concatenate\", new Parameter( \"list\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"insert before\", new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"position\", BuiltInType.NUMBER ), new Parameter( \"newItem\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"remove\", new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"position\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"reverse\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"index of\", new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"match\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"union\", new Parameter( \"list\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"distinct values\", new Parameter( \"list\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"flatten\", new Parameter( \"list\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"decimal\", new Parameter( \"n\", BuiltInType.NUMBER ), new Parameter( \"scale\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"floor\", new Parameter( \"n\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"ceiling\", new Parameter( \"n\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"decision table\", new Parameter( \"ctx\", BuiltInType.UNKNOWN ), new Parameter( \"outputs\", BuiltInType.UNKNOWN ), new Parameter( \"input expression list\", BuiltInType.UNKNOWN ), new Parameter( \"input values list\", BuiltInType.LIST ), new Parameter( \"output values\", BuiltInType.UNKNOWN ), new Parameter( \"rule list\", BuiltInType.LIST ), new Parameter( \"hit policy\", BuiltInType.STRING ), new Parameter( \"default output value\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"not\", new Parameter( \"negand\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"sort\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"sort\", new Parameter( \"ctx\", BuiltInType.UNKNOWN ), new Parameter( \"list\", BuiltInType.LIST ), new Parameter( \"precedes\", BuiltInType.FUNCTION ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"get entries\", new Parameter( \"m\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"get value\", new Parameter( \"m\", BuiltInType.UNKNOWN ), new Parameter( \"key\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"all\", new Parameter( \"b\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"all\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"all\", new Parameter( \"list\", BuiltInType.BOOLEAN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"any\", new Parameter( \"b\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"any\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"any\", new Parameter( \"list\", BuiltInType.BOOLEAN ) )");
        this.assertLine(lines, "BuiltInType.DURATION, \"abs\", new Parameter( \"n\", BuiltInType.DURATION ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"abs\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"abs\", new Parameter( \"n\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.DURATION, \"abs\", new Parameter( \"n\", BuiltInType.DURATION ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"modulo\", new Parameter( \"dividend\", BuiltInType.NUMBER ), new Parameter( \"divisor\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"product\", new Parameter( \"list\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"product\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"product\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"split\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"delimiter\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"split\", new Parameter( \"string\", BuiltInType.STRING ), new Parameter( \"delimiter\", BuiltInType.STRING ), new Parameter( \"flags\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"stddev\", new Parameter( \"list\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"stddev\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"stddev\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"mode\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"mode\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"sqrt\", new Parameter( \"number\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"log\", new Parameter( \"number\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"exp\", new Parameter( \"number\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"even\", new Parameter( \"number\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"odd\", new Parameter( \"number\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"median\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"median\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"day of week\", new Parameter( \"date\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"day of year\", new Parameter( \"date\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.STRING, \"month of year\", new Parameter( \"date\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"week of year\", new Parameter( \"date\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"is\", new Parameter( \"value1\", BuiltInType.UNKNOWN ), new Parameter( \"value2\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"after\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"after\", new Parameter( \"point\", BuiltInType.UNKNOWN ), new Parameter( \"range\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"after\", new Parameter( \"point1\", BuiltInType.UNKNOWN ), new Parameter( \"point2\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"after\", new Parameter( \"range\", BuiltInType.RANGE ), new Parameter( \"point\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"before\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"before\", new Parameter( \"point\", BuiltInType.UNKNOWN ), new Parameter( \"range\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"before\", new Parameter( \"point1\", BuiltInType.UNKNOWN ), new Parameter( \"point2\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"before\", new Parameter( \"range\", BuiltInType.RANGE ), new Parameter( \"point\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"coincides\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"coincides\", new Parameter( \"point1\", BuiltInType.UNKNOWN ), new Parameter( \"point2\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"starts\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"starts\", new Parameter( \"point\", BuiltInType.UNKNOWN ), new Parameter( \"range\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"started by\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"started by\", new Parameter( \"range\", BuiltInType.RANGE ), new Parameter( \"point\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"finishes\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"finishes\", new Parameter( \"point\", BuiltInType.UNKNOWN ), new Parameter( \"range\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"finished by\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"finished by\", new Parameter( \"range\", BuiltInType.RANGE ), new Parameter( \"point\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"during\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"during\", new Parameter( \"point\", BuiltInType.UNKNOWN ), new Parameter( \"range\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"includes\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"includes\", new Parameter( \"range\", BuiltInType.RANGE ), new Parameter( \"point\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"overlaps\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"overlaps before\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"overlaps after\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"meets\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"met by\", new Parameter( \"range1\", BuiltInType.RANGE ), new Parameter( \"range2\", BuiltInType.RANGE ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"time\", new Parameter( \"from\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"time\", new Parameter( \"hour\", BuiltInType.NUMBER ), new Parameter( \"minute\", BuiltInType.NUMBER ), new Parameter( \"second\", BuiltInType.NUMBER ), new Parameter( \"offset\", BuiltInType.DURATION ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"time\", new Parameter( \"hour\", BuiltInType.NUMBER ), new Parameter( \"minute\", BuiltInType.NUMBER ), new Parameter( \"second\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"time\", new Parameter( \"from\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date\", new Parameter( \"from\", BuiltInType.DATE_TIME ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date\", new Parameter( \"year\", BuiltInType.NUMBER ), new Parameter( \"month\", BuiltInType.NUMBER ), new Parameter( \"day\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"date\", new Parameter( \"from\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.DURATION, \"duration\", new Parameter( \"from\", BuiltInType.DURATION ) )");
        this.assertLine(lines, "BuiltInType.DURATION, \"duration\", new Parameter( \"from\", BuiltInType.STRING ) )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"now\" )");
        this.assertLine(lines, "BuiltInType.DATE_TIME, \"today\" )");
        this.assertLine(lines, "BuiltInType.STRING, \"code\", new Parameter( \"value\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"invoke\", new Parameter( \"ctx\", BuiltInType.UNKNOWN ), new Parameter( \"namespace\", BuiltInType.STRING ), new Parameter( \"model name\", BuiltInType.STRING ), new Parameter( \"decision name\", BuiltInType.STRING ), new Parameter( \"parameters\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"nn any\", new Parameter( \"list\", BuiltInType.BOOLEAN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"nn any\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"nn any\", new Parameter( \"b\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"nn all\", new Parameter( \"list\", BuiltInType.BOOLEAN ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"nn all\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.BOOLEAN, \"nn all\", new Parameter( \"b\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn count\", new Parameter( \"c\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn count\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"nn max\", new Parameter( \"c\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"nn max\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn mean\", new Parameter( \"list\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn mean\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn mean\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn median\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn median\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"nn min\", new Parameter( \"c\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.UNKNOWN, \"nn min\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"nn mode\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.LIST, \"nn mode\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn stddev\", new Parameter( \"list\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn stddev\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn stddev\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn sum\", new Parameter( \"list\", BuiltInType.NUMBER ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn sum\", new Parameter( \"list\", BuiltInType.LIST ) )");
        this.assertLine(lines, "BuiltInType.NUMBER, \"nn sum\", new Parameter( \"n\", BuiltInType.UNKNOWN ) )");
    }

    private void assertLine(List<String> lines, String line) {
        Assertions.assertThat(lines).contains((Object[])new String[]{String.format("definitions.add( new FunctionOverrideVariation( %s );", line)});
    }

    static {
        profiles.add((FEELProfile)new KieExtendedFEELProfile());
    }
}

