/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.gwt.functions.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.feel.gwt.functions.api.FunctionDefinitionStrings;
import org.kie.dmn.feel.gwt.functions.api.HumanReadable;
import org.kie.dmn.feel.gwt.functions.api.Parameter;
import org.kie.dmn.feel.lang.Type;

public class FunctionOverrideVariation
implements HumanReadable {
    private final Type returnType;
    private String functionName;
    private final Set<Parameter> parameters;

    public FunctionOverrideVariation(Type returnType, String functionName, Parameter ... parameters) {
        this.returnType = returnType;
        this.functionName = functionName;
        this.parameters = new HashSet<Parameter>(Arrays.asList(parameters));
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Set<Parameter> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    @Override
    public String toHumanReadableString() {
        return this.parameters.stream().map(Parameter::toHumanReadableString).collect(Collectors.joining(", "));
    }

    public FunctionDefinitionStrings toHumanReadableStrings() {
        StringBuilder humanReadableBuilder = new StringBuilder();
        StringBuilder templateBuilder = new StringBuilder();
        humanReadableBuilder.append(this.functionName);
        templateBuilder.append(this.functionName);
        humanReadableBuilder.append("(");
        templateBuilder.append("(");
        humanReadableBuilder.append(this.toHumanReadableString());
        templateBuilder.append(IntStream.rangeClosed(1, this.getParameters().size()).mapToObj(i -> "$" + i).collect(Collectors.joining(", ")));
        humanReadableBuilder.append(")");
        templateBuilder.append(")");
        return new FunctionDefinitionStrings(humanReadableBuilder.toString(), templateBuilder.toString());
    }
}

