/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.ExecutionFrame;
import org.kie.dmn.feel.lang.impl.ExecutionFrameImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.impl.RootExecutionFrame;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.api.GwtIncompatible;

public class EvaluationContextImpl
implements EvaluationContext {
    private final FEELEventListenersManager eventsManager;
    private ArrayDeque<ExecutionFrame> stack;
    private DMNRuntime dmnRuntime;
    private boolean performRuntimeTypeCheck = false;

    private EvaluationContextImpl(FEELEventListenersManager eventsManager, Deque<ExecutionFrame> stack) {
        this.eventsManager = eventsManager;
        this.stack = new ArrayDeque<ExecutionFrame>(stack);
    }

    public EvaluationContextImpl(FEELEventListenersManager eventsManager) {
        this(eventsManager, 32);
    }

    public EvaluationContextImpl(FEELEventListenersManager eventsManager, int size) {
        this(eventsManager, new ArrayDeque<ExecutionFrame>());
        this.push(RootExecutionFrame.INSTANCE);
        ExecutionFrameImpl global = new ExecutionFrameImpl(RootExecutionFrame.INSTANCE, size);
        this.push((ExecutionFrame)global);
    }

    public EvaluationContext current() {
        EvaluationContextImpl ec = new EvaluationContextImpl(this.eventsManager, new ArrayDeque<ExecutionFrame>(this.stack));
        ec.dmnRuntime = this.dmnRuntime;
        ec.performRuntimeTypeCheck = this.performRuntimeTypeCheck;
        return ec;
    }

    public void push(ExecutionFrame obj) {
        this.stack.push(obj);
    }

    public ExecutionFrame pop() {
        return this.stack.pop();
    }

    public ExecutionFrame peek() {
        return this.stack.peek();
    }

    public Deque<ExecutionFrame> getStack() {
        return this.stack;
    }

    public void enterFrame() {
        this.push((ExecutionFrame)new ExecutionFrameImpl(this.peek()));
    }

    public void enterFrame(int size) {
        this.push((ExecutionFrame)new ExecutionFrameImpl(this.peek(), size));
    }

    public void exitFrame() {
        this.pop();
    }

    public void setValue(String name, Object value) {
        this.peek().setValue(name, EvalHelper.coerceNumber(value));
    }

    public void setValues(Map<String, Object> values) {
        values.forEach(this::setValue);
    }

    public Object getValue(String name) {
        return this.peek().getValue(name);
    }

    public Object getValue(String[] name) {
        if (name.length == 1) {
            return this.getValue(name[0]);
        }
        if (name.length > 1) {
            Map actualObject = (Map)this.peek().getValue(name[0]);
            for (int i = 1; i < name.length - 1; ++i) {
                if ((actualObject = (Map)actualObject.get(name[i])) != null) continue;
                return null;
            }
            return actualObject.get(name[name.length - 1]);
        }
        return null;
    }

    public boolean isDefined(String name) {
        return this.peek().isDefined(name);
    }

    public boolean isDefined(String[] name) {
        if (name.length == 1) {
            return this.isDefined(name[0]);
        }
        if (name.length > 1) {
            Map actualObject = (Map)this.peek().getValue(name[0]);
            for (int i = 1; i < name.length - 1; ++i) {
                if ((actualObject = (Map)actualObject.get(name[i])) != null) continue;
                return false;
            }
            return actualObject.get(name[name.length - 1]) != null;
        }
        return false;
    }

    public Map<String, Object> getAllValues() {
        if (this.stack.peek().getRootObject() != null) {
            throw new RuntimeException();
        }
        int initialCapacity = (this.stack.peek().getAllValues().size() + this.stack.peekLast().getAllValues().size()) * 2;
        HashMap<String, Object> values = new HashMap<String, Object>(initialCapacity);
        Iterator<ExecutionFrame> it = this.stack.descendingIterator();
        while (it.hasNext()) {
            values.putAll(it.next().getAllValues());
        }
        return values;
    }

    public void notifyEvt(Supplier<FEELEvent> event) {
        FEELEventListenersManager.notifyListeners((FEELEventListenersManager)this.eventsManager, event);
    }

    public Collection<FEELEventListener> getListeners() {
        return this.eventsManager.getListeners();
    }

    public DMNRuntime getDMNRuntime() {
        return this.dmnRuntime;
    }

    @GwtIncompatible
    public ClassLoader getRootClassLoader() {
        return null;
    }

    public void setDMNRuntime(DMNRuntime runtime) {
        this.dmnRuntime = runtime;
    }

    public void setPerformRuntimeTypeCheck(boolean performRuntimeTypeCheck) {
        this.performRuntimeTypeCheck = performRuntimeTypeCheck;
    }

    public boolean isPerformRuntimeTypeCheck() {
        return this.performRuntimeTypeCheck;
    }

    public void setRootObject(Object v) {
        this.peek().setRootObject(v);
    }

    public Object getRootObject() {
        return this.peek().getRootObject();
    }
}

