/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SubstringFunction
extends BaseFEELFunction {
    public SubstringFunction() {
        super("substring");
    }

    public FEELFnResult<String> invoke(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start) {
        return this.invoke(string, start, null);
    }

    public FEELFnResult<String> invoke(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start, @ParameterName(value="length") Number length) {
        if (string == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "string", "cannot be null"));
        }
        if (start == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be null"));
        }
        if (length != null && length.intValue() <= 0) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "length", "must be a positive number when specified"));
        }
        if (start.intValue() == 0) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be zero"));
        }
        int stringLength = string.codePointCount(0, string.length());
        if (Math.abs(start.intValue()) > stringLength) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "parameter 'start position' inconsistent with the actual length of the parameter 'string'"));
        }
        return FEELFnResult.ofResult((Object)string.substring(start.intValue(), start.intValue() + length.intValue()));
    }
}

