/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.impl.NamedParameter;
import org.kie.dmn.feel.lang.types.FunctionSymbol;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.AppendFunction;
import org.kie.dmn.feel.runtime.functions.ConcatenateFunction;
import org.kie.dmn.feel.runtime.functions.ContainsFunction;
import org.kie.dmn.feel.runtime.functions.CountFunction;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.DurationFunction;
import org.kie.dmn.feel.runtime.functions.EndsWithFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ListContainsFunction;
import org.kie.dmn.feel.runtime.functions.MatchesFunction;
import org.kie.dmn.feel.runtime.functions.MeanFunction;
import org.kie.dmn.feel.runtime.functions.MinFunction;
import org.kie.dmn.feel.runtime.functions.NumberFunction;
import org.kie.dmn.feel.runtime.functions.ReplaceFunction;
import org.kie.dmn.feel.runtime.functions.StartsWithFunction;
import org.kie.dmn.feel.runtime.functions.StringFunction;
import org.kie.dmn.feel.runtime.functions.StringLengthFunction;
import org.kie.dmn.feel.runtime.functions.StringLowerCaseFunction;
import org.kie.dmn.feel.runtime.functions.StringUpperCaseFunction;
import org.kie.dmn.feel.runtime.functions.SublistFunction;
import org.kie.dmn.feel.runtime.functions.SubstringAfterFunction;
import org.kie.dmn.feel.runtime.functions.SubstringBeforeFunction;
import org.kie.dmn.feel.runtime.functions.SubstringFunction;
import org.kie.dmn.feel.runtime.functions.SumFunction;
import org.kie.dmn.feel.runtime.functions.TimeFunction;
import org.kie.dmn.feel.runtime.functions.YearsAndMonthsFunction;
import org.kie.dmn.feel.util.EvalHelper;

public abstract class BaseFEELFunction
implements FEELFunction {
    Logger logger = Logger.getLogger("NameOfYourLogger");
    private String name;
    private Symbol symbol;

    public BaseFEELFunction(String name) {
        this.name = name;
        this.symbol = new FunctionSymbol(name, (FEELFunction)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        ((FunctionSymbol)this.symbol).setId(name);
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Object invokeReflectively(EvaluationContext ctx, Object[] params) {
        this.logger.log(Level.SEVERE, "params count: " + params.length);
        this.logger.log(Level.SEVERE, "params are: " + params);
        for (Object param : params) {
            if (param == null) {
                this.logger.log(Level.SEVERE, "param null: " + param);
                continue;
            }
            this.logger.log(Level.SEVERE, "param: " + param.getClass() + " --- " + param);
        }
        if (this instanceof DateFunction) {
            return this.doCata(ctx, this.invokeDateFunction(params));
        }
        if (this instanceof TimeFunction) {
            return this.doCata(ctx, this.invokeTimeFunction(params));
        }
        if (this instanceof DateAndTimeFunction) {
            return this.doCata(ctx, this.invokeDateAndTimeFunction(params));
        }
        if (this instanceof DurationFunction) {
            return this.doCata(ctx, this.invokeDurationFunction(params));
        }
        if (this instanceof YearsAndMonthsFunction) {
            return this.doCata(ctx, this.invokeYearsAndMonthsFunction(params));
        }
        if (this instanceof StringFunction) {
            return this.doCata(ctx, this.invokeStringFunction(params));
        }
        if (this instanceof NumberFunction) {
            return this.doCata(ctx, this.invokeNumberFunction(params));
        }
        if (this instanceof SubstringFunction) {
            return this.doCata(ctx, this.invokeSubstringFunction(params));
        }
        if (this instanceof SubstringBeforeFunction) {
            return this.doCata(ctx, this.invokeSubstringBeforeFunction(params));
        }
        if (this instanceof SubstringAfterFunction) {
            return this.doCata(ctx, this.invokeSubstringAfterFunction(params));
        }
        if (this instanceof StringLengthFunction) {
            return this.doCata(ctx, this.invokeStringLengthFunction(params));
        }
        if (this instanceof StringUpperCaseFunction) {
            return this.doCata(ctx, this.invokeStringUpperCaseFunction(params));
        }
        if (this instanceof StringLowerCaseFunction) {
            return this.doCata(ctx, this.invokeStringLowerCaseFunction(params));
        }
        if (this instanceof ContainsFunction) {
            return this.doCata(ctx, this.invokeContainsFunction(params));
        }
        if (this instanceof StartsWithFunction) {
            return this.doCata(ctx, this.invokeStartsWithFunction(params));
        }
        if (this instanceof EndsWithFunction) {
            return this.doCata(ctx, this.invokeEndsWithFunction(params));
        }
        if (this instanceof MatchesFunction) {
            return this.doCata(ctx, this.invokeMatchesFunction(params));
        }
        if (this instanceof ReplaceFunction) {
            return this.doCata(ctx, this.invokeReplaceFunction(params));
        }
        if (this instanceof ListContainsFunction) {
            return this.doCata(ctx, this.invokeListContainsFunction(params));
        }
        if (this instanceof CountFunction) {
            return this.doCata(ctx, this.invokeCount(params));
        }
        if (this instanceof MinFunction) {
            return this.doCata(ctx, this.invokeMinFunction(params));
        }
        if (this instanceof SumFunction) {
            return this.doCata(ctx, this.invokeSum(params));
        }
        if (this instanceof MeanFunction) {
            return this.doCata(ctx, this.invokeMeanFunction(params));
        }
        if (this instanceof SublistFunction) {
            return this.doCata(ctx, this.invokeSublistFunction(params));
        }
        if (this instanceof AppendFunction) {
            return this.doCata(ctx, this.invokeAppendFunction(params));
        }
        if (this instanceof ConcatenateFunction) {
            return this.doCata(ctx, this.invokeConcatenateFunction(params));
        }
        return null;
    }

    private FEELFnResult<List<Object>> invokeConcatenateFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object list = this.getParam("list", params);
            Object item = this.getParam("item", params);
            if (list instanceof List) {
                return ((AppendFunction)this).invoke((List)list, (Object[])item);
            }
            return ((AppendFunction)this).invoke(list, (Object[])item);
        }
        if (params[0] instanceof List) {
            return ((AppendFunction)this).invoke((List)params[0], (Object[])params[1]);
        }
        return ((AppendFunction)this).invoke(params[0], (Object[])params[1]);
    }

    private FEELFnResult<List<Object>> invokeAppendFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object list = this.getParam("list", params);
            Object item = this.getParam("item", params);
            if (list instanceof List) {
                return ((AppendFunction)this).invoke((List)list, (Object[])item);
            }
            return ((AppendFunction)this).invoke(list, (Object[])item);
        }
        if (params[0] instanceof List) {
            return ((AppendFunction)this).invoke((List)params[0], (Object[])params[1]);
        }
        return ((AppendFunction)this).invoke(params[0], (Object[])params[1]);
    }

    private FEELFnResult<List> invokeSublistFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object list = this.getParam("list", params);
            Object startPosition = this.getParam("start position", params);
            Object length = this.getParam("length", params);
            return ((SublistFunction)this).invoke((List)list, (BigDecimal)startPosition, (BigDecimal)length);
        }
        if (params.length == 2) {
            return ((SublistFunction)this).invoke((List)params[0], (BigDecimal)params[1]);
        }
        return ((SublistFunction)this).invoke((List)params[0], (BigDecimal)params[1], (BigDecimal)params[2]);
    }

    private FEELFnResult<BigDecimal> invokeMeanFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object list = this.getParam("list", params);
            if (list instanceof List) {
                return ((MeanFunction)this).invoke((List)list);
            }
            if (list instanceof Number) {
                return ((MeanFunction)this).invoke((Number)list);
            }
        } else {
            if (params[0] instanceof List) {
                return ((MeanFunction)this).invoke((List)params[0]);
            }
            if (params[0] instanceof Number) {
                return ((MeanFunction)this).invoke((Number)params[0]);
            }
        }
        return ((MeanFunction)this).invoke((Object[])params[0]);
    }

    private FEELFnResult<Boolean> invokeListContainsFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object list = this.getParam("list", params);
            Object element = this.getParam("element", params);
            return ((ListContainsFunction)this).invoke((List)list, element);
        }
        return ((ListContainsFunction)this).invoke((List)params[0], params[1]);
    }

    private FEELFnResult<Object> invokeReplaceFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object input = this.getParam("input", params);
            Object pattern = this.getParam("pattern", params);
            Object replacement = this.getParam("replacement", params);
            Object flags = this.getParam("flags", params);
            return ((ReplaceFunction)this).invoke((String)input, (String)pattern, (String)replacement, (String)flags);
        }
        if (params.length == 3) {
            return ((ReplaceFunction)this).invoke((String)params[0], (String)params[1], (String)params[2]);
        }
        return ((ReplaceFunction)this).invoke((String)params[0], (String)params[1], (String)params[2], (String)params[3]);
    }

    private FEELFnResult<Boolean> invokeMatchesFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object input = this.getParam("input", params);
            Object pattern = this.getParam("pattern", params);
            Object flags = this.getParam("flags", params);
            return ((MatchesFunction)this).invoke((String)input, (String)pattern, (String)flags);
        }
        if (params.length == 2) {
            return ((MatchesFunction)this).invoke((String)params[0], (String)params[1]);
        }
        return ((MatchesFunction)this).invoke((String)params[0], (String)params[1], (String)params[2]);
    }

    private FEELFnResult<Boolean> invokeEndsWithFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            Object match = this.getParam("match", params);
            return ((EndsWithFunction)this).invoke((String)string, (String)match);
        }
        return ((EndsWithFunction)this).invoke((String)params[0], (String)params[1]);
    }

    private FEELFnResult<Boolean> invokeStartsWithFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            Object match = this.getParam("match", params);
            return ((StartsWithFunction)this).invoke((String)string, (String)match);
        }
        return ((StartsWithFunction)this).invoke((String)params[0], (String)params[1]);
    }

    private FEELFnResult<Boolean> invokeContainsFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            Object match = this.getParam("match", params);
            return ((ContainsFunction)this).invoke((String)string, (String)match);
        }
        return ((ContainsFunction)this).invoke((String)params[0], (String)params[1]);
    }

    private FEELFnResult<String> invokeStringLowerCaseFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            return ((StringLowerCaseFunction)this).invoke((String)string);
        }
        return ((StringLowerCaseFunction)this).invoke((String)params[0]);
    }

    private FEELFnResult<String> invokeStringUpperCaseFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            return ((StringUpperCaseFunction)this).invoke((String)string);
        }
        return ((StringUpperCaseFunction)this).invoke((String)params[0]);
    }

    private FEELFnResult<BigDecimal> invokeStringLengthFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            return ((StringLengthFunction)this).invoke((String)string);
        }
        return ((StringLengthFunction)this).invoke((String)params[0]);
    }

    private FEELFnResult<String> invokeSubstringAfterFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            Object match = this.getParam("match", params);
            return ((SubstringAfterFunction)this).invoke((String)string, (String)match);
        }
        return ((SubstringAfterFunction)this).invoke((String)params[0], (String)params[1]);
    }

    private FEELFnResult<String> invokeSubstringBeforeFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            Object match = this.getParam("match", params);
            return ((SubstringBeforeFunction)this).invoke((String)string, (String)match);
        }
        return ((SubstringBeforeFunction)this).invoke((String)params[0], (String)params[1]);
    }

    private FEELFnResult<String> invokeSubstringFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object string = this.getParam("string", params);
            Object startPosition = this.getParam("start position", params);
            Object length = this.getParam("length", params);
            return ((SubstringFunction)this).invoke((String)string, (Number)startPosition, (Number)length);
        }
        if (params.length == 2) {
            return ((SubstringFunction)this).invoke((String)params[0], (Number)params[1]);
        }
        return ((SubstringFunction)this).invoke((String)params[0], (Number)params[1], (Number)params[2]);
    }

    private FEELFnResult<String> invokeStringFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            if (params.length == 1) {
                Object from = this.getParam("from", params);
                return ((StringFunction)this).invoke(from);
            }
            Object mask = this.getParam("mask", params);
            Object p = this.getParam("p", params);
            return ((StringFunction)this).invoke((String)mask, (Object[])p);
        }
        if (params.length == 1) {
            return ((StringFunction)this).invoke(params[0]);
        }
        return ((StringFunction)this).invoke((String)params[0], (Object[])params[1]);
    }

    private FEELFnResult<TemporalAmount> invokeYearsAndMonthsFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object from = this.getParam("from", params);
            Object to = this.getParam("to", params);
            return ((YearsAndMonthsFunction)this).invoke((Temporal)from, (Temporal)to);
        }
        return ((YearsAndMonthsFunction)this).invoke((Temporal)params[0], (Temporal)params[1]);
    }

    private FEELFnResult<TemporalAmount> invokeDurationFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            Object from = this.getParam("from", params);
            if (from instanceof String) {
                return ((DurationFunction)this).invoke((String)from);
            }
            if (from instanceof TemporalAmount) {
                return ((DurationFunction)this).invoke((TemporalAmount)from);
            }
        }
        if (params[0] instanceof String) {
            return ((DurationFunction)this).invoke((String)params[0]);
        }
        return ((DurationFunction)this).invoke((TemporalAmount)params[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FEELFnResult<TemporalAccessor> invokeDateAndTimeFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            if (params.length == 1) {
                Object from = this.getParam("from", params);
                if (!(from instanceof String)) return ((DateAndTimeFunction)this).invoke((String)params[0]);
                return ((DateAndTimeFunction)this).invoke((String)from);
            }
            if (params.length == 2) {
                Object date = this.getParam("date", params);
                Object time = this.getParam("time", params);
                return ((DateAndTimeFunction)this).invoke((TemporalAccessor)date, (TemporalAccessor)time);
            }
            Object year = this.getParam("year", params);
            Object month = this.getParam("month", params);
            Object day = this.getParam("day", params);
            Object hour = this.getParam("hour", params);
            Object minute = this.getParam("minute", params);
            Object second = this.getParam("second", params);
            Object hourOffset = this.getParam("hour offset", params);
            Object timezone = this.getParam("timezone", params);
            if (hourOffset == null && timezone == null) {
                return ((DateAndTimeFunction)this).invoke((Number)year, (Number)month, (Number)day, (Number)hour, (Number)minute, (Number)second);
            }
            if (hourOffset != null) return ((DateAndTimeFunction)this).invoke((Number)year, (Number)month, (Number)day, (Number)hour, (Number)minute, (Number)second, (Number)hourOffset);
            return ((DateAndTimeFunction)this).invoke((Number)year, (Number)month, (Number)day, (Number)hour, (Number)minute, (Number)second, (String)timezone);
        }
        if (params.length == 6) {
            return ((DateAndTimeFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2], (Number)params[3], (Number)params[4], (Number)params[5]);
        }
        if (params.length != 7) return ((DateAndTimeFunction)this).invoke((String)params[0]);
        if (!(params[6] instanceof Number)) return ((DateAndTimeFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2], (Number)params[3], (Number)params[4], (Number)params[5], (String)params[6]);
        return ((DateAndTimeFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2], (Number)params[3], (Number)params[4], (Number)params[5], (Number)params[6]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private FEELFnResult<TemporalAccessor> invokeTimeFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            if (params.length != 1) {
                Object hour = this.getParam("hour", params);
                Object minute = this.getParam("minute", params);
                Object second = this.getParam("second", params);
                Object offset = this.getParam("offset", params);
                return ((TimeFunction)this).invoke((Number)hour, (Number)minute, (Number)second, (Duration)offset);
            }
            Object from = this.getParam("from", params);
            if (from instanceof String) {
                return ((TimeFunction)this).invoke((String)from);
            }
            if (from instanceof TemporalAccessor) {
                return ((TimeFunction)this).invoke((TemporalAccessor)from);
            }
        } else if (params.length == 1) {
            Object from = params[0];
            if (from instanceof String) {
                return ((TimeFunction)this).invoke((String)from);
            }
            if (from instanceof TemporalAccessor) {
                return ((TimeFunction)this).invoke((TemporalAccessor)from);
            }
        }
        if (params.length == 3) {
            return ((TimeFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2]);
        }
        return ((TimeFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2], (Duration)params[3]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FEELFnResult<TemporalAccessor> invokeDateFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            if (params.length == 1) {
                Object from = this.getParam("from", params);
                if (from instanceof String) {
                    return ((DateFunction)this).invoke((String)from);
                }
                if (!(from instanceof TemporalAccessor)) return ((DateFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2]);
                return ((DateFunction)this).invoke((TemporalAccessor)from);
            }
            Object year = this.getParam("year", params);
            Object month = this.getParam("month", params);
            Object day = this.getParam("day", params);
            return ((DateFunction)this).invoke((Number)year, (Number)month, (Number)day);
        }
        if (params.length != 1) return ((DateFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2]);
        Object from = params[0];
        if (from instanceof String) {
            return ((DateFunction)this).invoke((String)from);
        }
        if (!(from instanceof TemporalAccessor)) return ((DateFunction)this).invoke((Number)params[0], (Number)params[1], (Number)params[2]);
        return ((DateFunction)this).invoke((TemporalAccessor)from);
    }

    private FEELFnResult<BigDecimal> invokeNumberFunction(Object[] params) {
        if (this.isNamedParams(params)) {
            return ((NumberFunction)this).invoke((String)this.getParam("from", params), (String)this.getParam("grouping separator", params), (String)this.getParam("decimal separator", params));
        }
        return ((NumberFunction)this).invoke((String)params[0], (String)params[1], (String)params[2]);
    }

    private FEELFnResult<Object> invokeMaxFunction(Object[] params) {
        return null;
    }

    private FEELFnResult<Object> invokeMinFunction(Object[] params) {
        Object param;
        if (params.length == 1 && (param = this.resolveListParamOrDefault(params)) instanceof List) {
            return ((MinFunction)this).invoke((List)param);
        }
        return ((MinFunction)this).invoke(params);
    }

    private FEELFnResult<BigDecimal> invokeCount(Object[] params) {
        Object param;
        if (params.length == 1 && (param = this.resolveListParamOrDefault(params)) instanceof List) {
            return ((CountFunction)this).invoke((List)param);
        }
        return ((CountFunction)this).invoke(params);
    }

    private FEELFnResult<BigDecimal> invokeSum(Object[] params) {
        if (params.length == 1) {
            Object param = this.resolveListParamOrDefault(params);
            if (param instanceof List) {
                return ((SumFunction)this).invoke((List)param);
            }
            if (param instanceof Number) {
                return ((SumFunction)this).invoke((Number)param);
            }
        }
        return ((SumFunction)this).invoke(params);
    }

    private Object resolveListParamOrDefault(Object[] params) {
        if (this.isNamedParams(params)) {
            return this.getParam("list", params);
        }
        return params[0];
    }

    protected Object getParam(String paramName, Object[] params) {
        for (Object param : params) {
            if (!Objects.equals(paramName, ((NamedParameter)param).getName())) continue;
            return ((NamedParameter)param).getValue();
        }
        return null;
    }

    private boolean isNamedParams(Object[] params) {
        return params.length > 0 && params[0] instanceof NamedParameter;
    }

    private Object doCata(EvaluationContext ctx, FEELFnResult<?> either) {
        Object eitherResult = either.cata(left -> {
            ctx.notifyEvt(() -> left);
            return null;
        }, Function.identity());
        return eitherResult;
    }

    public Object invoke(EvaluationContext ctx, Object[] params) {
        throw new RuntimeException("This method should be overriden by classes that implement custom feel functions");
    }

    public List<List<FEELFunction.Param>> getParameters() {
        return Collections.emptyList();
    }

    private Object normalizeResult(Object result) {
        if (result != null && result.getClass().isArray()) {
            ArrayList<Object> objs = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(result); ++i) {
                objs.add(EvalHelper.coerceNumber(Array.get(result, i)));
            }
            return objs;
        }
        return EvalHelper.coerceNumber(result);
    }

    protected boolean isCustomFunction() {
        return false;
    }
}

