/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.kie.dmn.api.core.FEELPropertyAccessible;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELProperty;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.util.AssignableFromUtil;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.model.api.GwtIncompatible;

public class EvalHelper {
    @GwtIncompatible
    private static final Map<String, Method> accessorCache = new ConcurrentHashMap<String, Method>();

    public static String normalizeVariableName(String name) {
        int i;
        int i2;
        int firstValid;
        if (name == null || name.isEmpty()) {
            return name;
        }
        int size = name.length();
        for (firstValid = 0; firstValid < size && !EvalHelper.isValidChar(name.charAt(firstValid)); ++firstValid) {
        }
        if (firstValid == size) {
            return "";
        }
        int lastValid = 0;
        int trailing = 0;
        boolean inWhitespace = false;
        for (i2 = firstValid; i2 < size; ++i2) {
            if (EvalHelper.isValidChar(name.charAt(i2))) {
                lastValid = i2 + 1;
                inWhitespace = false;
                continue;
            }
            if (inWhitespace) break;
            inWhitespace = true;
            if (name.charAt(i2) != ' ') break;
        }
        for (i2 = lastValid; i2 < size && !EvalHelper.isValidChar(name.charAt(i2)); ++i2) {
            ++trailing;
        }
        if (lastValid + trailing == size) {
            return firstValid != 0 || trailing != 0 ? name.substring(firstValid, lastValid) : name;
        }
        int pos = 0;
        char[] target = new char[size - firstValid];
        for (i = firstValid; i < lastValid; ++i) {
            target[pos++] = name.charAt(i);
        }
        for (i = lastValid + 1; i < size; ++i) {
            char c = name.charAt(i);
            if (EvalHelper.isValidChar(c)) {
                if (inWhitespace) {
                    target[pos++] = 32;
                }
                target[pos++] = c;
                inWhitespace = false;
                continue;
            }
            inWhitespace = true;
        }
        return new String(target, 0, pos);
    }

    private static boolean isValidChar(char c) {
        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            return true;
        }
        return c != ' ' && c != '\u00a0' && !Character.isWhitespace(c);
    }

    public static BigDecimal getBigDecimalOrNull(Object value) {
        if (value == null || !(value instanceof Number) && !(value instanceof String) || value instanceof Double && (value.toString().equals("NaN") || value.toString().equals("Infinity") || value.toString().equals("-Infinity"))) {
            return null;
        }
        if (!AssignableFromUtil.isAssignableFrom(BigDecimal.class, value.getClass())) {
            if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof AtomicLong || value instanceof AtomicInteger) {
                value = new BigDecimal(((Number)value).longValue(), MathContext.DECIMAL128);
            } else if (value instanceof BigInteger) {
                value = new BigDecimal((BigInteger)value, MathContext.DECIMAL128);
            } else if (value instanceof String) {
                try {
                    value = new BigDecimal(((String)value).replaceFirst("^0+(?!$)", ""), MathContext.DECIMAL128);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else {
                value = new BigDecimal(EvalHelper.removeTrailingZeros(value.toString()), MathContext.DECIMAL128);
            }
        }
        return (BigDecimal)value;
    }

    public static Object coerceNumber(Object value) {
        if (value instanceof Number && !(value instanceof BigDecimal)) {
            return EvalHelper.getBigDecimalOrNull(value);
        }
        return value;
    }

    public static Boolean getBooleanOrNull(Object value) {
        if (value == null || !(value instanceof Boolean)) {
            return null;
        }
        return (Boolean)value;
    }

    public static String unescapeString(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() >= 2 && text.startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1, text.length() - 1);
        }
        if (text.indexOf(92) >= 0) {
            StringBuilder r = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\\') {
                    if (text.length() > i + 1) {
                        char cn = text.charAt(++i);
                        switch (cn) {
                            case 'b': {
                                r.append('\b');
                                break;
                            }
                            case 't': {
                                r.append('\t');
                                break;
                            }
                            case 'n': {
                                r.append('\n');
                                break;
                            }
                            case 'f': {
                                r.append('\f');
                                break;
                            }
                            case 'r': {
                                r.append('\r');
                                break;
                            }
                            case '\"': {
                                r.append('\"');
                                break;
                            }
                            case '\'': {
                                r.append('\'');
                                break;
                            }
                            case '\\': {
                                r.append('\\');
                                break;
                            }
                            case 'u': {
                                char[] chars;
                                String hex;
                                if (text.length() >= i + 5) {
                                    hex = text.substring(i + 1, i + 5);
                                    chars = Character.toChars(Integer.parseInt(hex, 16));
                                    r.append(chars);
                                    i += 4;
                                    break;
                                }
                                r.append("\\").append(cn);
                                break;
                            }
                            case 'U': {
                                char[] chars;
                                String hex;
                                if (text.length() >= i + 7) {
                                    hex = text.substring(i + 1, i + 7);
                                    chars = Character.toChars(Integer.parseInt(hex, 16));
                                    r.append(chars);
                                    i += 6;
                                    break;
                                }
                                r.append("\\").append(cn);
                                break;
                            }
                            default: {
                                r.append("\\").append(cn);
                                break;
                            }
                        }
                        continue;
                    }
                    r.append(c);
                    continue;
                }
                r.append(c);
            }
            text = r.toString();
        }
        return text;
    }

    public static PropertyValueResult getDefinedValue(Object current, String property) {
        Object result;
        if (current == null) {
            return PropertyValueResult.notDefined();
        }
        if (current instanceof Map) {
            result = ((Map)current).get(property);
            if (result == null && !((Map)current).containsKey(property)) {
                return PropertyValueResult.notDefined();
            }
        } else if (current instanceof ChronoPeriod) {
            switch (property) {
                case "years": {
                    result = ((ChronoPeriod)current).get(ChronoUnit.YEARS);
                    break;
                }
                case "months": {
                    result = ((ChronoPeriod)current).get(ChronoUnit.MONTHS) % 12L;
                    break;
                }
                default: {
                    return PropertyValueResult.notDefined();
                }
            }
        } else if (current instanceof Duration) {
            switch (property) {
                case "days": {
                    result = ((Duration)current).toDays();
                    break;
                }
                case "hours": {
                    result = ((Duration)current).toHours() % 24L;
                    break;
                }
                case "minutes": {
                    result = ((Duration)current).toMinutes() % 60L;
                    break;
                }
                case "seconds": {
                    result = ((Duration)current).getSeconds() % 60L;
                    break;
                }
                default: {
                    return PropertyValueResult.notDefined();
                }
            }
        } else if (current instanceof TemporalAccessor) {
            switch (property) {
                case "year": {
                    result = ((TemporalAccessor)current).get(ChronoField.YEAR);
                    break;
                }
                case "month": {
                    result = ((TemporalAccessor)current).get(ChronoField.MONTH_OF_YEAR);
                    break;
                }
                case "day": {
                    result = ((TemporalAccessor)current).get(ChronoField.DAY_OF_MONTH);
                    break;
                }
                case "hour": {
                    result = ((TemporalAccessor)current).get(ChronoField.HOUR_OF_DAY);
                    break;
                }
                case "minute": {
                    result = ((TemporalAccessor)current).get(ChronoField.MINUTE_OF_HOUR);
                    break;
                }
                case "second": {
                    result = ((TemporalAccessor)current).get(ChronoField.SECOND_OF_MINUTE);
                    break;
                }
                case "time offset": {
                    if (((TemporalAccessor)current).isSupported(ChronoField.OFFSET_SECONDS)) {
                        result = Duration.ofSeconds(((TemporalAccessor)current).get(ChronoField.OFFSET_SECONDS));
                        break;
                    }
                    result = null;
                    break;
                }
                case "weekday": {
                    result = ((TemporalAccessor)current).get(ChronoField.DAY_OF_WEEK);
                    break;
                }
                default: {
                    return PropertyValueResult.notDefined();
                }
            }
        } else if (current instanceof Range) {
            switch (property) {
                case "start included": {
                    result = ((Range)current).getLowBoundary() == Range.RangeBoundary.CLOSED ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case "start": {
                    result = ((Range)current).getLowEndPoint();
                    break;
                }
                case "end": {
                    result = ((Range)current).getHighEndPoint();
                    break;
                }
                case "end included": {
                    result = ((Range)current).getHighBoundary() == Range.RangeBoundary.CLOSED ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                default: {
                    return PropertyValueResult.notDefined();
                }
            }
        } else {
            return PropertyValueResult.notDefined();
        }
        result = EvalHelper.coerceNumber(result);
        return PropertyValueResult.ofValue(result);
    }

    public static Object getValue(Object current, String property) {
        return EvalHelper.getDefinedValue(current, property).getValueResult().getOrElse(null);
    }

    @GwtIncompatible
    public static Method getGenericAccessor(Class<?> clazz, String field) {
        String accessorQualifiedName = clazz.getCanonicalName() + "." + field;
        return accessorCache.computeIfAbsent(accessorQualifiedName, key -> Stream.of(clazz.getMethods()).filter(m -> Optional.ofNullable(m.getAnnotation(FEELProperty.class)).map(ann -> ann.value().equals(field)).orElse(false)).findFirst().orElse(EvalHelper.getAccessor(clazz, field)));
    }

    @GwtIncompatible
    public static void clearGenericAccessorCache() {
        accessorCache.clear();
    }

    @GwtIncompatible
    public static Method getAccessor(Class<?> clazz, String field) {
        try {
            return clazz.getMethod("get" + EvalHelper.ucFirst(field), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(field, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                try {
                    return clazz.getMethod("is" + EvalHelper.ucFirst(field), new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    return null;
                }
            }
        }
    }

    @GwtIncompatible
    public static Optional<String> propertyFromAccessor(Method accessor) {
        if (accessor.getParameterCount() != 0 || accessor.getReturnType().equals(Void.class)) {
            return Optional.empty();
        }
        String methodName = accessor.getName();
        if (methodName.startsWith("get")) {
            return Optional.of(EvalHelper.lcFirst(methodName.substring(3, methodName.length())));
        }
        if (methodName.startsWith("is")) {
            return Optional.of(EvalHelper.lcFirst(methodName.substring(2, methodName.length())));
        }
        return Optional.of(EvalHelper.lcFirst(methodName));
    }

    public static String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }

    public static String lcFirst(String name) {
        return name.toLowerCase().charAt(0) + name.substring(1);
    }

    public static Boolean compare(Object left, Object right, EvaluationContext ctx, BiPredicate<Comparable, Comparable> op) {
        Object r;
        Object l;
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof ChronoPeriod && right instanceof ChronoPeriod) {
            Long l2 = ComparablePeriod.toTotalMonths((ChronoPeriod)((ChronoPeriod)left));
            Long r2 = ComparablePeriod.toTotalMonths((ChronoPeriod)((ChronoPeriod)right));
            return op.test(l2, r2);
        }
        if (left instanceof TemporalAccessor && right instanceof TemporalAccessor) {
            l = (TemporalAccessor)left;
            r = (TemporalAccessor)right;
            if (BuiltInType.determineTypeFromInstance((Object)left) == BuiltInType.TIME && BuiltInType.determineTypeFromInstance((Object)right) == BuiltInType.TIME) {
                return op.test(Long.valueOf(EvalHelper.valuet((TemporalAccessor)l)), Long.valueOf(EvalHelper.valuet((TemporalAccessor)r)));
            }
            if (BuiltInType.determineTypeFromInstance((Object)left) == BuiltInType.DATE_TIME && BuiltInType.determineTypeFromInstance((Object)right) == BuiltInType.DATE_TIME) {
                return op.test(Long.valueOf(EvalHelper.valuedt((TemporalAccessor)l, r.query(TemporalQueries.zone()))), Long.valueOf(EvalHelper.valuedt((TemporalAccessor)r, l.query(TemporalQueries.zone()))));
            }
        }
        if (left instanceof String && right instanceof String || left instanceof Number && right instanceof Number || left instanceof Boolean && right instanceof Boolean || left instanceof Comparable && AssignableFromUtil.isAssignableFrom(left.getClass(), right.getClass())) {
            l = (Comparable)left;
            r = (Comparable)right;
            return op.test((Comparable)l, (Comparable)r);
        }
        return null;
    }

    public static Boolean isEqual(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return left == right;
        }
        if (left instanceof Collection && !(right instanceof Collection) && ((Collection)left).size() == 1) {
            left = ((Collection)left).toArray()[0];
        } else if (right instanceof Collection && !(left instanceof Collection) && ((Collection)right).size() == 1) {
            right = ((Collection)right).toArray()[0];
        }
        if (left instanceof Range && right instanceof Range) {
            return EvalHelper.isEqual((Range)left, (Range)right);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return EvalHelper.isEqual((Iterable)left, (Iterable)right);
        }
        if (left instanceof Map && right instanceof Map) {
            return EvalHelper.isEqual((Map)left, (Map)right);
        }
        if (left instanceof ChronoPeriod && right instanceof ChronoPeriod) {
            Long l2 = ComparablePeriod.toTotalMonths((ChronoPeriod)((ChronoPeriod)left));
            Long r2 = ComparablePeriod.toTotalMonths((ChronoPeriod)((ChronoPeriod)right));
            return EvalHelper.isEqual(l2, r2);
        }
        if (left instanceof TemporalAccessor && right instanceof TemporalAccessor) {
            TemporalAccessor l3 = (TemporalAccessor)left;
            TemporalAccessor r3 = (TemporalAccessor)right;
            if (BuiltInType.determineTypeFromInstance((Object)left) == BuiltInType.TIME && BuiltInType.determineTypeFromInstance((Object)right) == BuiltInType.TIME) {
                return EvalHelper.isEqual(EvalHelper.valuet(l3), EvalHelper.valuet(r3));
            }
            if (BuiltInType.determineTypeFromInstance((Object)left) == BuiltInType.DATE_TIME && BuiltInType.determineTypeFromInstance((Object)right) == BuiltInType.DATE_TIME) {
                return EvalHelper.isEqual(EvalHelper.valuedt(l3, r3.query(TemporalQueries.zone())), EvalHelper.valuedt(r3, l3.query(TemporalQueries.zone())));
            }
        }
        return EvalHelper.compare(left, right, ctx, (l, r) -> l.compareTo(r) == 0);
    }

    private static long valuedt(TemporalAccessor datetime, ZoneId otherTimezoneOffset) {
        ZoneId alternativeTZ = Optional.ofNullable(otherTimezoneOffset).orElse(ZoneOffset.UTC);
        if (datetime instanceof LocalDateTime) {
            return ((LocalDateTime)datetime).atZone(alternativeTZ).toEpochSecond();
        }
        if (datetime instanceof ZonedDateTime) {
            return ((ZonedDateTime)datetime).toEpochSecond();
        }
        if (datetime instanceof OffsetDateTime) {
            return ((OffsetDateTime)datetime).toEpochSecond();
        }
        throw new RuntimeException("valuedt() for " + datetime + " but is not a FEEL date and time " + datetime.getClass());
    }

    private static long valuet(TemporalAccessor time) {
        long result = 0L;
        result += (long)(time.get(ChronoField.HOUR_OF_DAY) * 3600);
        result += (long)(time.get(ChronoField.MINUTE_OF_HOUR) * 60);
        return result += (long)time.get(ChronoField.SECOND_OF_MINUTE);
    }

    public static Boolean isEqualDateTimeInSemanticD(TemporalAccessor left, TemporalAccessor right) {
        boolean result = true;
        Optional<Object> lY = Optional.ofNullable(left.isSupported(ChronoField.YEAR) ? Integer.valueOf(left.get(ChronoField.YEAR)) : null);
        Optional<Object> rY = Optional.ofNullable(right.isSupported(ChronoField.YEAR) ? Integer.valueOf(right.get(ChronoField.YEAR)) : null);
        result &= lY.equals(rY);
        Optional<Object> lM = Optional.ofNullable(left.isSupported(ChronoField.MONTH_OF_YEAR) ? Integer.valueOf(left.get(ChronoField.MONTH_OF_YEAR)) : null);
        Optional<Object> rM = Optional.ofNullable(right.isSupported(ChronoField.MONTH_OF_YEAR) ? Integer.valueOf(right.get(ChronoField.MONTH_OF_YEAR)) : null);
        result &= lM.equals(rM);
        Optional<Object> lD = Optional.ofNullable(left.isSupported(ChronoField.DAY_OF_MONTH) ? Integer.valueOf(left.get(ChronoField.DAY_OF_MONTH)) : null);
        Optional<Object> rD = Optional.ofNullable(right.isSupported(ChronoField.DAY_OF_MONTH) ? Integer.valueOf(right.get(ChronoField.DAY_OF_MONTH)) : null);
        result &= lD.equals(rD);
        return result &= EvalHelper.isEqualTimeInSemanticD(left, right).booleanValue();
    }

    public static Boolean isEqualTimeInSemanticD(TemporalAccessor left, TemporalAccessor right) {
        boolean result = true;
        Optional<Object> lH = Optional.ofNullable(left.isSupported(ChronoField.HOUR_OF_DAY) ? Integer.valueOf(left.get(ChronoField.HOUR_OF_DAY)) : null);
        Optional<Object> rH = Optional.ofNullable(right.isSupported(ChronoField.HOUR_OF_DAY) ? Integer.valueOf(right.get(ChronoField.HOUR_OF_DAY)) : null);
        result &= lH.equals(rH);
        Optional<Object> lM = Optional.ofNullable(left.isSupported(ChronoField.MINUTE_OF_HOUR) ? Integer.valueOf(left.get(ChronoField.MINUTE_OF_HOUR)) : null);
        Optional<Object> rM = Optional.ofNullable(right.isSupported(ChronoField.MINUTE_OF_HOUR) ? Integer.valueOf(right.get(ChronoField.MINUTE_OF_HOUR)) : null);
        result &= lM.equals(rM);
        Optional<Object> lS = Optional.ofNullable(left.isSupported(ChronoField.SECOND_OF_MINUTE) ? Integer.valueOf(left.get(ChronoField.SECOND_OF_MINUTE)) : null);
        Optional<Object> rS = Optional.ofNullable(right.isSupported(ChronoField.SECOND_OF_MINUTE) ? Integer.valueOf(right.get(ChronoField.SECOND_OF_MINUTE)) : null);
        result &= lS.equals(rS);
        Optional<ZoneId> lTZ = Optional.ofNullable(left.query(TemporalQueries.zone()));
        Optional<ZoneId> rTZ = Optional.ofNullable(right.query(TemporalQueries.zone()));
        return result &= lTZ.equals(rTZ);
    }

    private static Boolean isEqual(Range left, Range right) {
        return left.equals(right);
    }

    private static Boolean isEqual(Iterable left, Iterable right) {
        Iterator li = left.iterator();
        Iterator ri = right.iterator();
        while (li.hasNext() && ri.hasNext()) {
            Object r;
            Object l = li.next();
            if (EvalHelper.isEqual(l, r = ri.next()).booleanValue()) continue;
            return false;
        }
        return li.hasNext() == ri.hasNext();
    }

    private static Boolean isEqual(Map<?, ?> left, Map<?, ?> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (Map.Entry<?, ?> le : left.entrySet()) {
            Object r;
            Object l = le.getValue();
            if (EvalHelper.isEqual(l, r = right.get(le.getKey())).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Boolean isEqual(Object l, Object r) {
        if (l instanceof Iterable && r instanceof Iterable && !EvalHelper.isEqual((Iterable)l, (Iterable)r).booleanValue()) {
            return false;
        }
        if (l instanceof Map && r instanceof Map && !EvalHelper.isEqual((Map)l, (Map)r).booleanValue()) {
            return false;
        }
        if (l != null && r != null && !l.equals(r)) {
            return false;
        }
        if ((l == null || r == null) && l != r) {
            return false;
        }
        return true;
    }

    private static String removeTrailingZeros(String stringNumber) {
        String stringWithoutZeros = stringNumber.replaceAll("0*$", "");
        if (Character.isDigit(stringWithoutZeros.charAt(stringWithoutZeros.length() - 1))) {
            return stringWithoutZeros;
        }
        return stringWithoutZeros.substring(0, stringWithoutZeros.length() - 1);
    }

    public static class PropertyValueResult
    implements FEELPropertyAccessible.AbstractPropertyValueResult {
        private final boolean defined;
        private final Either<Exception, Object> valueResult;

        private PropertyValueResult(boolean isDefined, Either<Exception, Object> value) {
            this.defined = isDefined;
            this.valueResult = value;
        }

        public static PropertyValueResult notDefined() {
            return new PropertyValueResult(false, (Either<Exception, Object>)Either.ofLeft((Object)new UnsupportedOperationException("Property was not defined.")));
        }

        public static PropertyValueResult of(Either<Exception, Object> valueResult) {
            return new PropertyValueResult(true, valueResult);
        }

        public static PropertyValueResult ofValue(Object value) {
            return new PropertyValueResult(true, (Either<Exception, Object>)Either.ofRight((Object)value));
        }

        public boolean isDefined() {
            return this.defined;
        }

        public Either<Exception, Object> getValueResult() {
            return this.valueResult;
        }

        public Optional<Object> toOptional() {
            return (Optional)this.valueResult.cata(l -> Optional.empty(), Optional::of);
        }
    }
}

