/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.examples;

import java.util.Arrays;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.examples.ExamplesBaseTest;
import org.kie.dmn.feel.lang.examples.ExamplesTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDecisionTablesTest
extends ExamplesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ExamplesTest.class);
    private static FEEL feel;

    @BeforeClass
    public static void setupTest() {
        feel = FEEL.newInstance();
    }

    @Test
    public void testMain() {
        String expression = SimpleDecisionTablesTest.loadExpression("simple_decision_tables.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
        Assert.assertThat(context.get("result1"), (Matcher)CoreMatchers.is((Object)"Adult"));
        Assert.assertThat(context.get("result2"), (Matcher)CoreMatchers.is((Object)"Medium"));
        Assert.assertThat(context.get("result3"), (Matcher)CoreMatchers.is(Arrays.asList("out1b", "out2b")));
        Assert.assertThat(context.get("result4"), (Matcher)CoreMatchers.is(Arrays.asList("io1a", "io2a")));
    }

    @Test
    public void testt0004simpletableU() {
        String expression = SimpleDecisionTablesTest.loadExpression("t0004simpletableU.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
        Assert.assertThat(context.get("result1"), (Matcher)CoreMatchers.is((Object)"Approved"));
        Assert.assertThat(context.get("result2"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat(context.get("result3"), (Matcher)CoreMatchers.is((Object)"Declined"));
    }
}

