/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.util.EvalHelper;

public class InfixOpNode
extends BaseNode {
    private InfixOperator operator;
    private BaseNode left;
    private BaseNode right;

    public InfixOpNode(ParserRuleContext ctx, BaseNode left, String op, BaseNode right) {
        super(ctx);
        this.left = left;
        this.operator = InfixOperator.determineOperator(op);
        this.right = right;
    }

    public InfixOperator getOperator() {
        return this.operator;
    }

    public void setOperator(InfixOperator operator) {
        this.operator = operator;
    }

    public BaseNode getLeft() {
        return this.left;
    }

    public void setLeft(BaseNode left) {
        this.left = left;
    }

    public BaseNode getRight() {
        return this.right;
    }

    public void setRight(BaseNode right) {
        this.right = right;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object left = this.left.evaluate(ctx);
        Object right = this.right.evaluate(ctx);
        switch (this.operator) {
            case ADD: {
                return this.add(left, right, ctx);
            }
            case SUB: {
                return this.sub(left, right, ctx);
            }
            case MULT: {
                return this.math(left, right, ctx, (l, r) -> l.multiply((BigDecimal)r, MathContext.DECIMAL128));
            }
            case DIV: {
                return this.math(left, right, ctx, (l, r) -> l.divide((BigDecimal)r, MathContext.DECIMAL128));
            }
            case POW: {
                return this.math(left, right, ctx, (l, r) -> l.pow(r.intValue(), MathContext.DECIMAL128));
            }
            case AND: {
                return this.and(left, right, ctx);
            }
            case OR: {
                return this.or(left, right, ctx);
            }
            case LTE: {
                return this.comparison(left, right, ctx, (l, r) -> l.compareTo(r) <= 0);
            }
            case LT: {
                return this.comparison(left, right, ctx, (l, r) -> l.compareTo(r) < 0);
            }
            case GT: {
                return this.comparison(left, right, ctx, (l, r) -> l.compareTo(r) > 0);
            }
            case GTE: {
                return this.comparison(left, right, ctx, (l, r) -> l.compareTo(r) >= 0);
            }
            case EQ: {
                return this.equality(left, right, ctx, (l, r) -> l.compareTo(r) == 0);
            }
            case NE: {
                return this.equality(left, right, ctx, (l, r) -> l.compareTo(r) != 0);
            }
        }
        return null;
    }

    private Object add(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String && right instanceof String) {
            return (String)left + (String)right;
        }
        if (left instanceof Period && right instanceof Period) {
            return ((Period)left).plus((Period)right);
        }
        if (left instanceof Duration && right instanceof Duration) {
            return ((Duration)left).plus((Duration)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Period) {
            return ((ZonedDateTime)left).plus((Period)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Period) {
            return ((OffsetDateTime)left).plus((Period)right);
        }
        if (left instanceof LocalDateTime && right instanceof Period) {
            return ((LocalDateTime)left).plus((Period)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Duration) {
            return ((ZonedDateTime)left).plus((Duration)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Duration) {
            return ((OffsetDateTime)left).plus((Duration)right);
        }
        if (left instanceof LocalDateTime && right instanceof Duration) {
            return ((LocalDateTime)left).plus((Duration)right);
        }
        if (left instanceof Period && right instanceof ZonedDateTime) {
            return ((ZonedDateTime)right).plus((Period)left);
        }
        if (left instanceof Period && right instanceof OffsetDateTime) {
            return ((OffsetDateTime)right).plus((Period)left);
        }
        if (left instanceof Period && right instanceof LocalDateTime) {
            return ((LocalDateTime)right).plus((Period)left);
        }
        if (left instanceof Duration && right instanceof ZonedDateTime) {
            return ((ZonedDateTime)right).plus((Duration)left);
        }
        if (left instanceof Duration && right instanceof OffsetDateTime) {
            return ((OffsetDateTime)right).plus((Duration)left);
        }
        if (left instanceof Duration && right instanceof LocalDateTime) {
            return ((LocalDateTime)right).plus((Duration)left);
        }
        if (left instanceof LocalTime && right instanceof Duration) {
            return ((LocalDateTime)left).plus((Duration)left);
        }
        if (left instanceof Duration && right instanceof LocalTime) {
            return ((LocalDateTime)right).plus((Duration)left);
        }
        if (left instanceof OffsetTime && right instanceof Duration) {
            return ((OffsetTime)left).plus((Duration)left);
        }
        if (left instanceof Duration && right instanceof OffsetTime) {
            return ((OffsetTime)right).plus((Duration)left);
        }
        return this.math(left, right, ctx, (l, r) -> l.add((BigDecimal)r, MathContext.DECIMAL128));
    }

    private Object sub(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof ZonedDateTime && right instanceof ZonedDateTime) {
            return Duration.between((ZonedDateTime)left, (ZonedDateTime)right);
        }
        if (left instanceof OffsetDateTime && right instanceof OffsetDateTime) {
            return Duration.between((OffsetDateTime)left, (OffsetDateTime)right);
        }
        if (left instanceof LocalDateTime && right instanceof LocalDateTime) {
            return Duration.between((LocalDateTime)left, (LocalDateTime)right);
        }
        if (left instanceof LocalTime && right instanceof LocalTime) {
            return Duration.between((LocalTime)left, (LocalTime)right);
        }
        if (left instanceof OffsetTime && right instanceof OffsetTime) {
            return Duration.between((OffsetTime)left, (OffsetTime)right);
        }
        if (left instanceof Period && right instanceof Period) {
            return ((Period)left).minus((Period)right);
        }
        if (left instanceof Duration && right instanceof Duration) {
            return ((Duration)left).minus((Duration)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Period) {
            return ((ZonedDateTime)left).minus((Period)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Period) {
            return ((OffsetDateTime)left).minus((Period)right);
        }
        if (left instanceof LocalDateTime && right instanceof Period) {
            return ((LocalDateTime)left).minus((Period)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Duration) {
            return ((ZonedDateTime)left).minus((Duration)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Duration) {
            return ((OffsetDateTime)left).minus((Duration)right);
        }
        if (left instanceof LocalDateTime && right instanceof Duration) {
            return ((LocalDateTime)left).minus((Duration)right);
        }
        if (left instanceof LocalTime && right instanceof Duration) {
            return ((LocalDateTime)left).minus((Duration)left);
        }
        if (left instanceof OffsetTime && right instanceof Duration) {
            return ((OffsetTime)left).minus((Duration)left);
        }
        return this.math(left, right, ctx, (l, r) -> l.subtract((BigDecimal)r, MathContext.DECIMAL128));
    }

    private Object math(Object left, Object right, EvaluationContext ctx, BinaryOperator<BigDecimal> op) {
        BigDecimal l = EvalHelper.getBigDecimalOrNull(left);
        BigDecimal r = EvalHelper.getBigDecimalOrNull(right);
        if (l == null || r == null) {
            return null;
        }
        try {
            return op.apply(l, r);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    private Object and(Object left, Object right, EvaluationContext ctx) {
        Boolean l = EvalHelper.getBooleanOrNull(left);
        Boolean r = EvalHelper.getBooleanOrNull(right);
        if (l == null && r == null || l == null && r == true || r == null && l.booleanValue()) {
            return null;
        }
        if (l == null || r == null) {
            return false;
        }
        return l != false && r != false;
    }

    private Object or(Object left, Object right, EvaluationContext ctx) {
        Boolean l = EvalHelper.getBooleanOrNull(left);
        Boolean r = EvalHelper.getBooleanOrNull(right);
        if (l == null && r == null || l == null && r == false || r == null && !l.booleanValue()) {
            return null;
        }
        if (l == null || r == null) {
            return true;
        }
        return l != false || r != false;
    }

    private Object comparison(Object left, Object right, EvaluationContext ctx, BiPredicate<Comparable, Comparable> op) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String && right instanceof String || left instanceof Number && right instanceof Number || left instanceof Boolean && right instanceof Boolean || left instanceof Comparable && left.getClass().isAssignableFrom(right.getClass())) {
            Comparable l = (Comparable)left;
            Comparable r = (Comparable)right;
            return op.test(l, r);
        }
        return null;
    }

    private Object equality(Object left, Object right, EvaluationContext ctx, BiPredicate<Comparable, Comparable> op) {
        if (left == null && right == null) {
            return this.operator == InfixOperator.EQ;
        }
        if (left == null || right == null) {
            return this.operator == InfixOperator.NE;
        }
        if (left instanceof Range && right instanceof Range) {
            return this.operator == InfixOperator.NE ^ this.isEqual((Range)left, (Range)right);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return this.operator == InfixOperator.NE ^ this.isEqual((Iterable)left, (Iterable)right);
        }
        if (left instanceof Map && right instanceof Map) {
            return this.operator == InfixOperator.NE ^ this.isEqual((Map)left, (Map)right);
        }
        return this.comparison(left, right, ctx, op);
    }

    private Boolean isEqual(Range left, Range right) {
        return left.equals(right);
    }

    private Boolean isEqual(Iterable left, Iterable right) {
        Iterator li = left.iterator();
        Iterator ri = right.iterator();
        while (li.hasNext() && ri.hasNext()) {
            Object r;
            Object l = li.next();
            if (this.isEqual(l, r = ri.next())) continue;
            return false;
        }
        return li.hasNext() == ri.hasNext();
    }

    private Boolean isEqual(Map<?, ?> left, Map<?, ?> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (Map.Entry<?, ?> le : left.entrySet()) {
            Object r;
            Object l = le.getValue();
            if (this.isEqual(l, r = right.get(le.getKey()))) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(Object l, Object r) {
        if (l instanceof Iterable && r instanceof Iterable && !this.isEqual((Iterable)l, (Iterable)r).booleanValue()) {
            return false;
        }
        if (l instanceof Map && r instanceof Map && !this.isEqual((Map)l, (Map)r).booleanValue()) {
            return false;
        }
        if (l != null && r != null && !l.equals(r)) {
            return false;
        }
        return l != null && r != null || l == r;
    }

    public static enum InfixOperator {
        ADD("+"),
        SUB("-"),
        MULT("*"),
        DIV("/"),
        POW("**"),
        LTE("<="),
        LT("<"),
        GT(">"),
        GTE(">="),
        EQ("="),
        NE("!="),
        AND("and"),
        OR("or");

        public final String symbol;

        private InfixOperator(String symbol) {
            this.symbol = symbol;
        }

        public static InfixOperator determineOperator(String symbol) {
            for (InfixOperator op : InfixOperator.values()) {
                if (!op.symbol.equals(symbol)) continue;
                return op;
            }
            throw new IllegalArgumentException("No operator found for symbol '" + symbol + "'");
        }
    }
}

