/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.UnaryTest;

public class UnaryTestNode
extends BaseNode {
    private UnaryOperator operator;
    private BaseNode value;

    public UnaryTestNode(ParserRuleContext ctx, String op, BaseNode value) {
        super(ctx);
        this.operator = UnaryOperator.determineOperator(op);
        this.value = value;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(UnaryOperator operator) {
        this.operator = operator;
    }

    public BaseNode getValue() {
        return this.value;
    }

    public void setValue(BaseNode value) {
        this.value = value;
    }

    @Override
    public UnaryTest evaluate(EvaluationContext ctx) {
        Comparable val = (Comparable)this.value.evaluate(ctx);
        switch (this.operator) {
            case LTE: {
                return o -> o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) <= 0);
            }
            case LT: {
                return o -> o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) < 0);
            }
            case GT: {
                return o -> o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) > 0);
            }
            case GTE: {
                return o -> o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) >= 0);
            }
        }
        return null;
    }

    public static enum UnaryOperator {
        LTE("<="),
        LT("<"),
        GT(">"),
        GTE(">=");

        public final String symbol;

        private UnaryOperator(String symbol) {
            this.symbol = symbol;
        }

        public static UnaryOperator determineOperator(String symbol) {
            for (UnaryOperator op : UnaryOperator.values()) {
                if (!op.symbol.equals(symbol)) continue;
                return op;
            }
            throw new IllegalArgumentException("No operator found for symbol '" + symbol + "'");
        }
    }
}

