/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.decisiontables;

public enum HitPolicy {
    UNIQUE("U", "UNIQUE"),
    FIRST("F", "FIRST"),
    PRIORITY("P", "PRIORITY"),
    ANY("A", "ANY"),
    COLLECT("C", "COLLECT"),
    COLLECT_SUM("C+", "COLLECT SUM"),
    COLLECT_COUNT("C#", "COLLECT COUNT"),
    COLLECT_MIN("C<", "COLLECT MIN"),
    COLLECT_MAX("C>", "COLLECT MAX"),
    RULE_ORDER("R", "RULE ORDER"),
    OUTPUT_ORDER("O", "OUTPUT ORDER");

    private final String shortName;
    private final String longName;

    private HitPolicy(String shortName, String longName) {
        this.shortName = shortName;
        this.longName = longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public static HitPolicy fromString(String policy) {
        policy = policy.toUpperCase();
        for (HitPolicy c : HitPolicy.values()) {
            if (!c.shortName.equals(policy) && !c.longName.equals(policy)) continue;
            return c;
        }
        throw new IllegalArgumentException("Unknown hit policy: " + policy);
    }
}

