/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class DateTimeFunction
extends BaseFEELFunction {
    public DateTimeFunction() {
        super("date and time");
    }

    public TemporalAccessor apply(@ParameterName(value="from") String val) {
        if (val != null) {
            try {
                return DateTimeFormatter.ISO_DATE_TIME.parseBest(val, ZonedDateTime::from, OffsetDateTime::from, LocalDateTime::from);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public TemporalAccessor apply(@ParameterName(value="date") Temporal date, @ParameterName(value="time") Temporal time) {
        if (date != null && time != null) {
            if (date instanceof LocalDate && time instanceof LocalTime) {
                return LocalDateTime.of((LocalDate)date, (LocalTime)time);
            }
            if (date instanceof LocalDate && time instanceof OffsetTime) {
                return ZonedDateTime.of((LocalDate)date, LocalTime.from(time), ZoneOffset.from(time));
            }
        }
        return null;
    }
}

