/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class EvalHelper {
    public static String normalizeVariableName(String name) {
        return name.replaceAll("\\s+", " ");
    }

    public static BigDecimal getBigDecimalOrNull(Object value) {
        if (!(value instanceof Number)) {
            return null;
        }
        if (!BigDecimal.class.isAssignableFrom(value.getClass())) {
            value = value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof AtomicLong || value instanceof AtomicInteger ? new BigDecimal(((Number)value).longValue(), MathContext.DECIMAL128) : (value instanceof BigInteger ? new BigDecimal(((BigInteger)value).toString(), MathContext.DECIMAL128) : new BigDecimal(((Number)value).doubleValue(), MathContext.DECIMAL128));
        }
        return (BigDecimal)value;
    }

    public static Boolean getBooleanOrNull(Object value) {
        if (value == null || !(value instanceof Boolean)) {
            return null;
        }
        return (Boolean)value;
    }

    public static String stripQuotes(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() >= 2 && text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static Object getValue(Object current, String property) throws IllegalAccessException, InvocationTargetException {
        if (current == null) {
            return null;
        }
        if (current instanceof Map) {
            current = ((Map)current).get(property);
        } else {
            Method getter = EvalHelper.getAccessor(current.getClass(), property);
            current = getter.invoke(current, new Object[0]);
        }
        return current;
    }

    public static Method getAccessor(Class<?> clazz, String field) {
        try {
            return clazz.getMethod("get" + EvalHelper.ucFirst(field), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(field, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                try {
                    return clazz.getMethod("is" + EvalHelper.ucFirst(field), new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    return null;
                }
            }
        }
    }

    public static String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }
}

