/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.parser.feel11.profiles.DoCompileFEELProfile;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public abstract class BaseFEELTest {
    @Parameterized.Parameter(value=3)
    public FEEL_TARGET testFEELTarget;
    private FEEL feel = null;
    @Parameterized.Parameter(value=0)
    public String expression;
    @Parameterized.Parameter(value=1)
    public Object result;
    @Parameterized.Parameter(value=2)
    public FEELEvent.Severity severity;

    @Test
    public void testExpression() {
        this.feel = this.testFEELTarget == FEEL_TARGET.JAVA_TRANSLATED ? FEEL.newInstance(Arrays.asList(new DoCompileFEELProfile())) : FEEL.newInstance();
        FEELEventListener listener = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        this.feel.addListener(listener);
        this.feel.addListener(evt -> System.out.println(evt));
        this.assertResult(this.expression, this.result);
        if (this.severity != null) {
            ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
            ((FEELEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.atLeastOnce())).onEvent((FEELEvent)captor.capture());
            Assert.assertThat((Object)((FEELEvent)captor.getValue()).getSeverity(), (Matcher)Matchers.is((Object)this.severity));
        } else {
            ((FEELEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onEvent((FEELEvent)org.mockito.Matchers.any(FEELEvent.class));
        }
    }

    protected void assertResult(String expression, Object result) {
        if (result == null) {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(expression), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else if (result instanceof Class) {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(expression), (Matcher)Matchers.is((Matcher)Matchers.instanceOf((Class)((Class)result))));
        } else {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(expression), (Matcher)Matchers.is((Object)result));
        }
    }

    protected static List<Object[]> enrichWith4thParameter(Object[][] cases) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (Object[] c : cases) {
            results.add(new Object[]{c[0], c[1], c[2], FEEL_TARGET.AST_INTERPRETED});
        }
        for (Object[] c : cases) {
            results.add(new Object[]{c[0], c[1], c[2], FEEL_TARGET.JAVA_TRANSLATED});
        }
        return results;
    }

    public static enum FEEL_TARGET {
        AST_INTERPRETED,
        JAVA_TRANSLATED;

    }
}

