/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.TimeFunction;
import org.kie.dmn.feel.runtime.functions.extended.CodeFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class CodeFunctionTest {
    private CodeFunction codeFunction;

    @Before
    public void setUp() throws Exception {
        this.codeFunction = new CodeFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke(null), "null");
    }

    @Test
    public void invokeString() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)"test"), "\"test\"");
    }

    @Test
    public void invokeBigDecimal() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)BigDecimal.valueOf(10.7)), "10.7");
    }

    @Test
    public void invokeLocalDate() {
        LocalDate localDate = LocalDate.now();
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)localDate), "date( \"" + localDate.toString() + "\" )");
    }

    @Test
    public void invokeLocalTime() {
        LocalTime localTime = LocalTime.now();
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)localTime), "time( \"" + TimeFunction.FEEL_TIME.format(localTime) + "\" )");
    }

    @Test
    public void invokeOffsetTime() {
        OffsetTime offsetTime = OffsetTime.now();
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)offsetTime), "time( \"" + TimeFunction.FEEL_TIME.format(offsetTime) + "\" )");
    }

    @Test
    public void invokeLocalDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)localDateTime), "date and time( \"" + DateAndTimeFunction.FEEL_DATE_TIME.format(localDateTime) + "\" )");
    }

    @Test
    public void invokeOffsetDateTime() {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)offsetDateTime), "date and time( \"" + DateAndTimeFunction.FEEL_DATE_TIME.format(offsetDateTime) + "\" )");
    }

    @Test
    public void invokeZonedDateTime() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)zonedDateTime), "date and time( \"" + DateAndTimeFunction.REGION_DATETIME_FORMATTER.format(zonedDateTime) + "\" )");
    }

    @Test
    public void invokeDurationZero() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ZERO), "duration( \"PT0S\" )");
    }

    @Test
    public void invokeDurationDays() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofDays(9L)), "duration( \"P9D\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofDays(-9L)), "duration( \"-P9D\" )");
    }

    @Test
    public void invokeDurationHours() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofHours(9L)), "duration( \"PT9H\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofHours(200L)), "duration( \"P8DT8H\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofHours(-200L)), "duration( \"-P8DT8H\" )");
    }

    @Test
    public void invokeDurationMinutes() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofMinutes(9L)), "duration( \"PT9M\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofMinutes(200L)), "duration( \"PT3H20M\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofMinutes(5000L)), "duration( \"P3DT11H20M\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofMinutes(-5000L)), "duration( \"-P3DT11H20M\" )");
    }

    @Test
    public void invokeDurationSeconds() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofSeconds(9L)), "duration( \"PT9S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofSeconds(200L)), "duration( \"PT3M20S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofSeconds(5000L)), "duration( \"PT1H23M20S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofSeconds(90061L)), "duration( \"P1DT1H1M1S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofSeconds(-90061L)), "duration( \"-P1DT1H1M1S\" )");
    }

    @Test
    public void invokeDurationNanosMillis() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofNanos(25L)), "duration( \"PT0.000000025S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofNanos(10000L)), "duration( \"PT0.00001S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofNanos(10025L)), "duration( \"PT0.000010025S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofMillis(1500L)), "duration( \"PT1.5S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofMillis(90061025L)), "duration( \"P1DT1H1M1.025S\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Duration.ofMillis(-90061025L)), "duration( \"-P1DT1H1M1.025S\" )");
    }

    @Test
    public void invokePeriodZero() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Period.ZERO), "duration( \"P0M\" )");
    }

    @Test
    public void invokePeriodYears() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Period.ofYears(24)), "duration( \"P24Y\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Period.ofYears(-24)), "duration( \"-P24Y\" )");
    }

    @Test
    public void invokePeriodMonths() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Period.ofMonths(2)), "duration( \"P2M\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Period.ofMonths(27)), "duration( \"P2Y3M\" )");
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)Period.ofMonths(-27)), "duration( \"-P2Y3M\" )");
    }

    @Test
    public void invokeListEmpty() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke(Collections.emptyList()), "[ ]");
    }

    @Test
    public void invokeListNonEmpty() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(1);
        values.add(BigDecimal.valueOf(10.5));
        values.add("test");
        FunctionTestUtil.assertResult(this.codeFunction.invoke(values), "[ 1, 10.5, \"test\" ]");
    }

    @Test
    public void invokeRangeOpenOpen() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN)), "( 12 .. 15 )");
    }

    @Test
    public void invokeRangeOpenClosed() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED)), "( 12 .. 15 ]");
    }

    @Test
    public void invokeRangeClosedOpen() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN)), "[ 12 .. 15 )");
    }

    @Test
    public void invokeRangeClosedClosed() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED)), "[ 12 .. 15 ]");
    }

    @Test
    public void invokeContextEmpty() {
        FunctionTestUtil.assertResult(this.codeFunction.invoke(new HashMap()), "{ }");
    }

    @Test
    public void invokeContextNonEmpty() {
        HashMap<String, String> childContextMap = new HashMap<String, String>();
        childContextMap.put("childKey1", "childValue1");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("key1", "value1");
        contextMap.put("key2", childContextMap);
        FunctionTestUtil.assertResult(this.codeFunction.invoke(contextMap), "{ key1 : \"value1\", key2 : { childKey1 : \"childValue1\" } }");
    }
}

