/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.ContainsFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class ContainsFunctionTest {
    private ContainsFunction containsFunction;

    @Before
    public void setUp() {
        this.containsFunction = new ContainsFunction();
    }

    @Test
    public void invokeParamsNull() {
        FunctionTestUtil.assertResultError(this.containsFunction.invoke((String)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.containsFunction.invoke(null, "test"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.containsFunction.invoke("test", null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeContains() {
        FunctionTestUtil.assertResult(this.containsFunction.invoke("test", "es"), true);
        FunctionTestUtil.assertResult(this.containsFunction.invoke("test", "t"), true);
        FunctionTestUtil.assertResult(this.containsFunction.invoke("testy", "y"), true);
    }

    @Test
    public void invokeNotContains() {
        FunctionTestUtil.assertResult(this.containsFunction.invoke("test", "ex"), false);
        FunctionTestUtil.assertResult(this.containsFunction.invoke("test", "u"), false);
        FunctionTestUtil.assertResult(this.containsFunction.invoke("test", "esty"), false);
    }
}

