/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.marshaller;

import java.util.function.Function;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.marshaller.FEELMarshaller;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.DateTimeFunction;
import org.kie.dmn.feel.runtime.functions.DurationFunction;
import org.kie.dmn.feel.runtime.functions.NumberFunction;
import org.kie.dmn.feel.runtime.functions.StringFunction;
import org.kie.dmn.feel.runtime.functions.TimeFunction;

public class FEELStringMarshaller
implements FEELMarshaller<String> {
    public static final FEELStringMarshaller INSTANCE = new FEELStringMarshaller();

    private FEELStringMarshaller() {
    }

    @Override
    public String marshall(Object value) {
        if (value == null) {
            return "null";
        }
        return (String)BuiltInFunctions.getFunction(StringFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
    }

    @Override
    public Object unmarshall(Type feelType, String value) {
        if ("null".equals(value)) {
            return null;
        }
        if (feelType.equals(BuiltInType.NUMBER)) {
            return BuiltInFunctions.getFunction(NumberFunction.class).invoke(value, null, null).cata(BuiltInType.justNull(), Function.identity());
        }
        if (feelType.equals(BuiltInType.STRING)) {
            return value;
        }
        if (feelType.equals(BuiltInType.DATE)) {
            return BuiltInFunctions.getFunction(DateFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
        }
        if (feelType.equals(BuiltInType.TIME)) {
            return BuiltInFunctions.getFunction(TimeFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
        }
        if (feelType.equals(BuiltInType.DATE_TIME)) {
            return BuiltInFunctions.getFunction(DateTimeFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
        }
        if (feelType.equals(BuiltInType.DURATION)) {
            return BuiltInFunctions.getFunction(DurationFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
        }
        if (feelType.equals(BuiltInType.BOOLEAN)) {
            return Boolean.parseBoolean(value);
        }
        if (feelType.equals(BuiltInType.RANGE) || feelType.equals(BuiltInType.FUNCTION) || feelType.equals(BuiltInType.LIST) || feelType.equals(BuiltInType.CONTEXT) || feelType.equals(BuiltInType.UNARY_TEST)) {
            throw new UnsupportedOperationException("FEELStringMarshaller is unable to unmarshall complex types like: " + feelType.getName());
        }
        return null;
    }
}

