/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.Duration;
import java.time.Period;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class StringFunction
extends BaseFEELFunction {
    private final long SECONDS_IN_A_MINUTE = 60L;
    private final long SECONDS_IN_AN_HOUR = 3600L;
    private final long SECONDS_IN_A_DAY = 86400L;
    private final long NANOSECONDS_PER_SECOND = 1000000000L;

    public StringFunction() {
        super("string");
    }

    public FEELFnResult<String> invoke(@ParameterName(value="from") Object val) {
        if (val == null) {
            return FEELFnResult.ofResult(null);
        }
        StringBuilder sb = new StringBuilder();
        this.formatValue(sb, val);
        return FEELFnResult.ofResult(sb.toString());
    }

    public FEELFnResult<String> invoke(@ParameterName(value="mask") String mask, @ParameterName(value="p") Object[] params) {
        if (mask == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "mask", "cannot be null"));
        }
        return FEELFnResult.ofResult(String.format(mask, params));
    }

    private void formatValue(StringBuilder sb, Object val) {
        if (val instanceof Duration) {
            this.formatDuration(sb, (Duration)val);
        } else if (val instanceof Period) {
            this.formatPeriod(sb, (Period)val);
        } else if (val instanceof List) {
            this.formatList(sb, (List)val);
        } else if (val instanceof Range) {
            this.formatRange(sb, (Range)val);
        } else if (val instanceof Map) {
            this.formatContext(sb, (Map)val);
        } else {
            sb.append(val.toString());
        }
    }

    private void formatContext(StringBuilder sb, Map context) {
        sb.append("{ ");
        int count = 0;
        for (Map.Entry val : context.entrySet()) {
            if (count > 0) {
                sb.append(", ");
            }
            this.formatValue(sb, val.getKey());
            sb.append(" : ");
            this.formatValue(sb, val.getValue());
            ++count;
        }
        if (!context.isEmpty()) {
            sb.append(" ");
        }
        sb.append("}");
    }

    private void formatRange(StringBuilder sb, Range val) {
        sb.append(val.getLowBoundary() == Range.RangeBoundary.OPEN ? "( " : "[ ");
        this.formatValue(sb, val.getLowEndPoint());
        sb.append(" .. ");
        this.formatValue(sb, val.getHighEndPoint());
        sb.append(val.getHighBoundary() == Range.RangeBoundary.OPEN ? " )" : " ]");
    }

    private void formatList(StringBuilder sb, List list) {
        sb.append("[ ");
        int count = 0;
        for (Object val : list) {
            if (count > 0) {
                sb.append(", ");
            }
            this.formatValue(sb, val);
            ++count;
        }
        if (!list.isEmpty()) {
            sb.append(" ");
        }
        sb.append("]");
    }

    private void formatPeriod(StringBuilder sb, Period val) {
        long months;
        long totalMonths = val.toTotalMonths();
        if (totalMonths == 0L) {
            sb.append("P0M");
            return;
        }
        if (totalMonths < 0L) {
            sb.append("-P");
        } else {
            sb.append('P');
        }
        long years = Math.abs(totalMonths / 12L);
        if (years != 0L) {
            sb.append(years).append('Y');
        }
        if ((months = Math.abs(totalMonths % 12L)) != 0L) {
            sb.append(months).append('M');
        }
    }

    private void formatDuration(StringBuilder sb, Duration val) {
        if (val.getSeconds() == 0L && val.getNano() == 0) {
            sb.append("PT0S");
            return;
        }
        long days = val.getSeconds() / 86400L;
        long hours = val.getSeconds() % 86400L / 3600L;
        long minutes = val.getSeconds() % 3600L / 60L;
        long seconds = val.getSeconds() % 60L;
        if (val.isNegative()) {
            sb.append("-");
        }
        sb.append("P");
        if (days != 0L) {
            sb.append(Math.abs(days));
            sb.append("D");
        }
        if (hours != 0L || minutes != 0L || seconds != 0L || val.getNano() != 0) {
            sb.append("T");
            if (hours != 0L) {
                sb.append(Math.abs(hours));
                sb.append("H");
            }
            if (minutes != 0L) {
                sb.append(Math.abs(minutes));
                sb.append("M");
            }
            if (seconds != 0L || val.getNano() != 0) {
                if (seconds < 0L && val.getNano() > 0) {
                    if (seconds == -1L) {
                        sb.append("0");
                    } else {
                        sb.append(Math.abs(seconds + 1L));
                    }
                } else {
                    sb.append(Math.abs(seconds));
                }
                if (val.getNano() > 0) {
                    int pos = sb.length();
                    if (seconds < 0L) {
                        sb.append(2000000000L - (long)val.getNano());
                    } else {
                        sb.append((long)val.getNano() + 1000000000L);
                    }
                    while (sb.charAt(sb.length() - 1) == '0') {
                        sb.setLength(sb.length() - 1);
                    }
                    sb.setCharAt(pos, '.');
                }
                sb.append('S');
            }
        }
    }
}

