/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.codegen.feel11.ProcessedExpression;
import org.kie.dmn.feel.codegen.feel11.ProcessedFEELUnit;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.lang.impl.CompilerContextImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.FEELParserTest;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FEELParserSeverityTest {
    private static final Logger LOG = LoggerFactory.getLogger(FEELParserSeverityTest.class);

    @Test
    public void testUnexistentOperatorGTGT() {
        String inputExpression = "1 >> 2";
        ASTNode number = this.parseSeverity(inputExpression, FEELEvent.Severity.WARN);
        Assert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        Assert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        FEELParserTest.assertLocation(inputExpression, number);
    }

    @Test
    public void testUnexistentOperatorGTGTGT() {
        String inputExpression = "1 >>> 2";
        ASTNode number = this.parseSeverity(inputExpression, FEELEvent.Severity.WARN);
        Assert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        Assert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        FEELParserTest.assertLocation(inputExpression, number);
    }

    @Test
    public void testUnexistentOperatorEQEQ() {
        String inputExpression = "1 == 2";
        ASTNode number = this.parseSeverity(inputExpression, FEELEvent.Severity.WARN);
        Assert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        Assert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        FEELParserTest.assertLocation(inputExpression, number);
    }

    @Test
    public void testUnexistentOperatorInvokeLTLT() {
        String inputExpression = "{ m: <<18 }.m(16)";
        ASTNode number = this.parseSeverity(inputExpression, FEELEvent.Severity.WARN);
        Assert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        Assert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Type.class)));
        FEELParserTest.assertLocation(inputExpression, number);
    }

    private ASTNode parseSeverity(String input, FEELEvent.Severity severity) {
        FEELEventListenersManager mgr = new FEELEventListenersManager();
        CompilerContextImpl ctx = new CompilerContextImpl(mgr);
        FEELEventListener listener = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        mgr.addListener(listener);
        mgr.addListener(e -> LOG.info("{}", (Object)e));
        ProcessedExpression processedExpression = new ProcessedExpression(input, (CompilerContext)ctx, ProcessedFEELUnit.DefaultMode.Interpreted, Collections.emptyList());
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.atLeastOnce())).onEvent((FEELEvent)captor.capture());
        Assert.assertThat((Object)((FEELEvent)captor.getValue()).getSeverity(), (Matcher)CoreMatchers.is((Object)severity));
        return processedExpression.getInterpreted().getASTNode();
    }
}

