/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNMeanFunction;

public class MeanFunctionTest {
    private NNMeanFunction meanFunction;

    @Before
    public void setUp() {
        this.meanFunction = new NNMeanFunction();
    }

    @Test
    public void invokeNumberNull() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((Number)null), null);
    }

    @Test
    public void invokeNumberBigDecimal() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((Number)BigDecimal.TEN), BigDecimal.TEN);
    }

    @Test
    public void invokeNumberInteger() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((Number)10), BigDecimal.TEN);
    }

    @Test
    public void invokeNumberDoubleWithoutDecimalPart() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((Number)10.0), BigDecimal.valueOf(10L));
    }

    @Test
    public void invokeNumberDoubleWithDecimalPart() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((Number)10.1), BigDecimal.valueOf(10.1));
    }

    @Test
    public void invokeNumberFloat() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((Number)Float.valueOf(10.1f)), BigDecimal.valueOf(10.1));
    }

    @Test
    public void invokeUnconvertableNumber() {
        FunctionTestUtil.assertResultError(this.meanFunction.invoke((Number)Double.POSITIVE_INFINITY), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.meanFunction.invoke((Number)Double.NEGATIVE_INFINITY), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.meanFunction.invoke((Number)Double.NaN), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListNull() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((List)null), null);
    }

    @Test
    public void invokeListEmpty() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(Collections.emptyList()), null);
    }

    @Test
    public void invokeListTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.meanFunction.invoke(Arrays.asList(1, "test")), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(Arrays.asList(20, 30, null, 40L, null, BigDecimal.TEN)), BigDecimal.valueOf(25L));
    }

    @Test
    public void invokeListWithIntegers() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(Arrays.asList(10, 20, 30)), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.meanFunction.invoke(Arrays.asList(10, 20, 30, -10, -20, -30)), BigDecimal.ZERO);
        FunctionTestUtil.assertResult(this.meanFunction.invoke(Arrays.asList(0, 0, 1)), new BigDecimal("0.3333333333333333333333333333333333"));
    }

    @Test
    public void invokeListWithDoubles() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(Arrays.asList(10.0, 20.0, 30.0)), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.meanFunction.invoke(Arrays.asList(10.2, 20.2, 30.2)), BigDecimal.valueOf(20.2));
    }

    @Test
    public void invokeArrayNull() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke((Object[])null), null);
    }

    @Test
    public void invokeArrayEmpty() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(new Object[0]), null);
    }

    @Test
    public void invokeArrayTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.meanFunction.invoke(new Object[]{1, "test"}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayWithIntegers() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(new Object[]{10, 20, 30}), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.meanFunction.invoke(new Object[]{10, 20, 30, -10, -20, -30}), BigDecimal.ZERO);
        FunctionTestUtil.assertResult(this.meanFunction.invoke(new Object[]{0, 0, 1}), new BigDecimal("0.3333333333333333333333333333333333"));
    }

    @Test
    public void invokeArrayWithDoubles() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(new Object[]{10.0, 20.0, 30.0}), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.meanFunction.invoke(new Object[]{10.2, 20.2, 30.2}), BigDecimal.valueOf(20.2));
    }

    @Test
    public void invokeArrayParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.meanFunction.invoke(new Object[]{20, 30, null, 40L, null, BigDecimal.TEN}), BigDecimal.valueOf(25L));
    }
}

