/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.marshaller;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.marshaller.FEELCodeMarshaller;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

@RunWith(value=Parameterized.class)
public class FEELCodeMarshallerTest {
    @Parameterized.Parameter(value=0)
    public Object value;
    @Parameterized.Parameter(value=1)
    public String result;

    @Parameterized.Parameters(name="{index}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{BigDecimal.valueOf(2L), "2"}, {BigDecimal.valueOf(2.0), "2.0"}, {BigDecimal.valueOf(0.2), "0.2"}, {BigDecimal.valueOf(0.2), "0.2"}, {BigDecimal.valueOf(-0.2), "-0.2"}, {"foo", "\"foo\""}, {"", "\"\""}, {true, "true"}, {false, "false"}, {LocalDate.of(2017, 7, 1), "date( \"2017-07-01\" )"}, {LocalTime.of(14, 32, 55), "time( \"14:32:55\" )"}, {OffsetTime.of(14, 32, 55, 125000000, ZoneOffset.ofHours(-5)), "time( \"14:32:55.125-05:00\" )"}, {OffsetTime.of(14, 32, 55, 125000000, ZoneOffset.UTC), "time( \"14:32:55.125Z\" )"}, {LocalDateTime.of(2017, 6, 30, 10, 49, 11), "date and time( \"2017-06-30T10:49:11\" )"}, {LocalDateTime.of(2017, 6, 30, 10, 49, 11, 650000000), "date and time( \"2017-06-30T10:49:11.65\" )"}, {OffsetDateTime.of(2017, 6, 30, 10, 49, 11, 650000000, ZoneOffset.ofHours(3)), "date and time( \"2017-06-30T10:49:11.65+03:00\" )"}, {Duration.ofDays(5L).plusHours(4L).plusMinutes(23L).plusSeconds(55L), "duration( \"P5DT4H23M55S\" )"}, {Duration.ofDays(-5L).minusHours(4L).minusMinutes(23L).minusSeconds(55L), "duration( \"-P5DT4H23M55S\" )"}, {Duration.ofDays(23L), "duration( \"P23D\" )"}, {Duration.ofDays(-23L), "duration( \"-P23D\" )"}, {Duration.ofHours(23L), "duration( \"PT23H\" )"}, {Duration.ofHours(-23L), "duration( \"-PT23H\" )"}, {Duration.ofMinutes(23L), "duration( \"PT23M\" )"}, {Duration.ofMinutes(-23L), "duration( \"-PT23M\" )"}, {Duration.ofSeconds(23L), "duration( \"PT23S\" )"}, {Duration.ofSeconds(-23L), "duration( \"-PT23S\" )"}, {Duration.ofDays(0L), "duration( \"PT0S\" )"}, {Duration.ofHours(124L), "duration( \"P5DT4H\" )"}, {Duration.ofSeconds(63749283L), "duration( \"P737DT20H8M3S\" )"}, {Period.of(4, 5, 12), "duration( \"P4Y5M\" )"}, {Period.of(4, 25, 0), "duration( \"P6Y1M\" )"}, {Period.of(-4, -25, 0), "duration( \"-P6Y1M\" )"}, {Period.of(0, 0, -4), "duration( \"P0M\" )"}, {Period.of(0, 0, 0), "duration( \"P0M\" )"}, {ComparablePeriod.of((int)4, (int)5, (int)12), "duration( \"P4Y5M\" )"}, {ComparablePeriod.of((int)4, (int)25, (int)0), "duration( \"P6Y1M\" )"}, {ComparablePeriod.of((int)-4, (int)-25, (int)0), "duration( \"-P6Y1M\" )"}, {ComparablePeriod.of((int)0, (int)0, (int)-4), "duration( \"P0M\" )"}, {ComparablePeriod.of((int)0, (int)0, (int)0), "duration( \"P0M\" )"}, {Arrays.asList(1, 2, 3, 4), "[ 1, 2, 3, 4 ]"}, {Arrays.asList("foo", "bar", "baz"), "[ \"foo\", \"bar\", \"baz\" ]"}, {Arrays.asList(Duration.ofDays(4L), Duration.ofDays(2L), Duration.ofHours(25L)), "[ duration( \"P4D\" ), duration( \"P2D\" ), duration( \"P1DT1H\" ) ]"}, {Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4)), "[ [ 1, 2 ], [ 3, 4 ] ]"}, {new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.OPEN), "[ \"a\" .. \"z\" )"}, {new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.ofHours(30L), (Comparable)Duration.ofHours(50L), Range.RangeBoundary.OPEN), "[ duration( \"P1DT6H\" ) .. duration( \"P2DT2H\" ) )"}, {new LinkedHashMap(){
            {
                this.put("Full Name", "John Doe");
                this.put("Age", 35);
                this.put("Date of Birth", LocalDate.of(1982, 6, 9));
            }
        }, "{ Full Name : \"John Doe\", Age : 35, Date of Birth : date( \"1982-06-09\" ) }"}, {null, "null"}};
        return Arrays.asList(cases);
    }

    @Test
    public void testExpression() {
        this.assertResult(this.value, this.result);
    }

    protected void assertResult(Object value, String result) {
        if (result == null) {
            Assert.assertThat((String)("Marshalling: '" + value + "'"), (Object)FEELCodeMarshaller.INSTANCE.marshall(value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            Assert.assertThat((String)("Marshalling: '" + value + "'"), (Object)FEELCodeMarshaller.INSTANCE.marshall(value), (Matcher)Matchers.is((Object)result));
        }
    }
}

