/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSupport;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualBasicFunctionInvocationTest {
    public static final Logger LOG = LoggerFactory.getLogger(ManualBasicFunctionInvocationTest.class);

    @Test
    public void testManualContext() {
        ManualFilterExpression compiledExpression = new ManualFilterExpression();
        LOG.debug("{}", (Object)compiledExpression);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext();
        Object result = compiledExpression.apply(emptyContext);
        LOG.debug("{}", result);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(3L)));
    }

    public static class ManualFilterExpression
    implements CompiledFEELExpression {
        public static final BigDecimal K_1 = new BigDecimal(1, MathContext.DECIMAL128);
        public static final BigDecimal K_2 = new BigDecimal(2, MathContext.DECIMAL128);
        public static final BigDecimal K_3 = new BigDecimal(3, MathContext.DECIMAL128);

        public Object apply(EvaluationContext feelExprCtx) {
            return CompiledFEELSupport.invoke((EvaluationContext)feelExprCtx, (Object)feelExprCtx.getValue("max"), Arrays.asList(K_1, K_2, K_3));
        }
    }
}

