/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.kie.dmn.feel.lang.Scope;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Lexer;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.feel.util.TokenTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeImpl
implements Scope {
    public static final Logger LOG = LoggerFactory.getLogger(ScopeImpl.class);
    private String name;
    private Scope parentScope;
    private Map<String, Symbol> symbols = new LinkedHashMap<String, Symbol>();
    private Map<String, Scope> childScopes = new LinkedHashMap<String, Scope>();
    private TokenTree tokenTree;
    private Type type;

    public ScopeImpl() {
    }

    public ScopeImpl(String name, Scope parentScope) {
        this.name = name;
        this.parentScope = parentScope;
        if (parentScope != null) {
            parentScope.addChildScope(this);
        }
    }

    public ScopeImpl(String name, Scope parentScope, Type type) {
        this(name, parentScope);
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Scope getParentScope() {
        return this.parentScope;
    }

    @Override
    public boolean define(Symbol symbol) {
        if (this.symbols.containsKey(symbol.getId())) {
            return false;
        }
        this.symbols.put(EvalHelper.normalizeVariableName(symbol.getId()), symbol);
        if (this.tokenTree != null) {
            this.tokenTree.addName(this.tokenize(symbol.getId()));
        }
        return true;
    }

    @Override
    public Symbol resolve(String id) {
        Symbol s = this.symbols.get(EvalHelper.normalizeVariableName(id));
        if (s == null && this.parentScope != null) {
            return this.parentScope.resolve(id);
        }
        return s;
    }

    @Override
    public Symbol resolve(String[] qualifiedName) {
        Symbol root = this.symbols.get(EvalHelper.normalizeVariableName(qualifiedName[0]));
        if (root == null && this.parentScope != null) {
            return this.parentScope.resolve(qualifiedName);
        }
        if (root != null) {
            Symbol currentSymbol = root;
            for (int i = 1; i < qualifiedName.length && currentSymbol != null; ++i) {
                currentSymbol = currentSymbol.getScope().resolve(EvalHelper.normalizeVariableName(qualifiedName[i]));
            }
            return currentSymbol;
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentScope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    @Override
    public void addChildScope(Scope scope) {
        this.childScopes.put(scope.getName(), scope);
    }

    @Override
    public Map<String, Scope> getChildScopes() {
        return this.childScopes;
    }

    public void setChildScopes(Map<String, Scope> childScopes) {
        this.childScopes = childScopes;
    }

    @Override
    public Map<String, Symbol> getSymbols() {
        return this.symbols;
    }

    @Override
    public void start(String token) {
        LOG.trace("[{}]: start() {}", (Object)this.name, (Object)token);
        if (this.tokenTree == null) {
            this.initializeTokenTree();
        }
        this.tokenTree.start(token);
        if (this.parentScope != null) {
            this.parentScope.start(token);
        }
    }

    @Override
    public boolean followUp(String token, boolean isPredict) {
        LOG.trace("[{}]: followUp() {}", (Object)this.name, (Object)token);
        boolean parent = this.parentScope != null ? this.parentScope.followUp(token, isPredict) : false;
        return this.tokenTree.followUp(token, !isPredict) || parent;
    }

    private void initializeTokenTree() {
        LOG.trace("[{}]: initializeTokenTree()");
        this.tokenTree = new TokenTree();
        for (String symbol : this.symbols.keySet()) {
            List<String> tokens = this.tokenize(symbol);
            this.tokenTree.addName(tokens);
        }
    }

    private List<String> tokenize(String symbol) {
        ANTLRInputStream input = new ANTLRInputStream(symbol);
        FEEL_1_1Lexer lexer = new FEEL_1_1Lexer((CharStream)input);
        ArrayList<String> tokens = new ArrayList<String>();
        Token token = lexer.nextToken();
        while (token.getType() != -1) {
            tokens.add(token.getText());
            token = lexer.nextToken();
        }
        return tokens;
    }

    public String toString() {
        return "Scope{ name='" + this.name + '\'' + ", parentScope='" + (this.parentScope != null ? this.parentScope.getName() : "<null>") + "' }";
    }

    @Override
    public Type getType() {
        return this.type;
    }
}

