/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;

public final class FunctionTestUtil {
    public static <T> void assertResult(FEELFnResult<T> result, T expectedResult) {
        if (expectedResult == null) {
            FunctionTestUtil.assertResultNull(result);
        } else {
            FunctionTestUtil.assertResultNotError(result);
            Object resultValue = result.cata(left -> null, right -> right);
            Assertions.assertThat((Object)resultValue).isNotNull();
            Assertions.assertThat((Object)resultValue).isEqualTo(expectedResult);
        }
    }

    public static void assertResultBigDecimal(FEELFnResult<BigDecimal> result, BigDecimal expectedResult) {
        FunctionTestUtil.assertResultNotError(result);
        BigDecimal resultValue = (BigDecimal)result.cata(left -> null, right -> right);
        Assertions.assertThat((BigDecimal)resultValue).isNotNull();
        Assertions.assertThat((BigDecimal)resultValue).isEqualTo((Object)expectedResult);
    }

    public static <T> void assertResultList(FEELFnResult<List<T>> result, List<Object> expectedResult) {
        FunctionTestUtil.assertResultNotError(result);
        List resultList = (List)result.cata(left -> null, right -> right);
        Assertions.assertThat((List)resultList).hasSize(expectedResult.size());
        if (expectedResult.isEmpty()) {
            Assertions.assertThat((List)resultList).isEmpty();
        } else {
            Assertions.assertThat((List)resultList).containsAll(expectedResult);
        }
    }

    public static <T> void assertPredicateOnResult(FEELFnResult<?> result, Class<T> clazz, Predicate<T> assertion) {
        FunctionTestUtil.assertResultNotError(result);
        Object resultValue = result.cata(left -> null, clazz::cast);
        Assertions.assertThat((Object)resultValue).isNotNull();
        Assertions.assertThat((boolean)assertion.test(resultValue)).isTrue();
    }

    public static <T> void assertResultNull(FEELFnResult<T> result) {
        FunctionTestUtil.assertResultNotError(result);
        Object invokedResult = result.cata(left -> null, right -> right);
        Assertions.assertThat((Object)invokedResult).isNull();
    }

    public static <T> void assertResultNotError(FEELFnResult<T> result) {
        Assertions.assertThat(result).isNotNull();
        Assertions.assertThat((boolean)result.isRight()).isTrue();
    }

    public static <T> void assertResultError(FEELFnResult<T> result, Class expectedErrorEventClass) {
        Assertions.assertThat(result).isNotNull();
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        FEELEvent resultEvent = (FEELEvent)result.cata(left -> left, right -> null);
        FunctionTestUtil.checkErrorEvent(resultEvent, expectedErrorEventClass);
    }

    public static void checkErrorEvent(FEELEvent errorEvent, Class errorEventClass) {
        Assertions.assertThat((Object)errorEvent).isNotNull();
        Assertions.assertThat((Comparable)errorEvent.getSeverity()).isEqualTo((Object)FEELEvent.Severity.ERROR);
        Assertions.assertThat((Object)errorEvent).isInstanceOf(errorEventClass);
    }

    private FunctionTestUtil() {
    }
}

