/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.BaseFEELTest;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class FEELContextsTest
extends BaseFEELTest {
    @Parameterized.Parameters(name="{3}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"{ first name : \"Bob\", birthday : date(\"1978-09-12\"), salutation : \"Hello \"+first name }", new HashMap<String, Object>(){
            {
                this.put("first name", "Bob");
                this.put("birthday", LocalDate.of(1978, 9, 12));
                this.put("salutation", "Hello Bob");
            }
        }, null}, {"{ full name : { first name: \"Bob\", last name : \"Doe\" }, birthday : date(\"1978-09-12\"), salutation : \"Hello \"+full name.first name }", new HashMap<String, Object>(){
            {
                this.put("full name", new HashMap<String, Object>(){
                    {
                        this.put("first name", "Bob");
                        this.put("last name", "Doe");
                    }
                });
                this.put("birthday", LocalDate.of(1978, 9, 12));
                this.put("salutation", "Hello Bob");
            }
        }, null}, {"{ startdate: date(\"1978-09-12\"), enddate: date(\"1978-10-13\"), rangedates: [startdate..enddate] }", new HashMap<String, Object>(){
            {
                this.put("startdate", LocalDate.of(1978, 9, 12));
                this.put("enddate", LocalDate.of(1978, 10, 13));
                this.put("rangedates", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.CLOSED));
            }
        }, null}, {"5\u00a0+\u00a03", BigDecimal.valueOf(8L), null}, {"{ first\u00a0\u00a0name : \"Bob\", salutation : \"Hello \"+first\u00a0\u00a0name+\"!\"}.salutation", "Hello Bob!", null}, {"{ first\u00a0\u00a0name : \"Bob\", salutation : \"Hello \"+first\u00a0name+\"!\"}.salutation", "Hello Bob!", null}, {"{ first\u00a0\u00a0name : \"Bob\", salutation : \"Hello \"+first  name+\"!\"}.salutation", "Hello Bob!", null}, {"{ first name : \"Bob\", salutation : \"Hello \"+first\u00a0name+\"!\"}.salutation", "Hello Bob!", null}, {"{ \"first name\" : \"Bob\", salutation : \"Hello \"+first name+\"!\"}.salutation", "Hello Bob!", null}, {"{ \"first name\" : \"Bob\", salutation : \"Hello \"+first\u00a0name+\"!\"}.salutation", "Hello Bob!", null}, {"{ \"a\" : 1, b : 2, \"c\": a+b}.c", BigDecimal.valueOf(3L), null}, {"[{a: {b: [1]}}, {a: {b: [2.1, 2.2]}}, {a: {b: [3]}}, {a: {b: [4, 5]}}].a.b", Arrays.asList(Arrays.asList(new BigDecimal(1)), Arrays.asList(new BigDecimal("2.1"), new BigDecimal("2.2")), Arrays.asList(new BigDecimal(3)), Arrays.asList(new BigDecimal(4), new BigDecimal(5))), null}, {"{a:{p:{x:10,y:5}},b : a.p.x*10+a.p.y*10}.b", BigDecimal.valueOf(150L), null}, {"{a:{p:{x:10,y:5}},b : a.p.y < a.p.x and a.p.x > a.p.y }.b", Boolean.TRUE, null}, {"{a:{p:{x:10,y:5}},b : a.p.y < a.p.x or a.p.y <= a.p.x }.b", Boolean.TRUE, null}, {"{a: 1, b: 2, a: 3}", null, FEELEvent.Severity.ERROR}};
        return FEELContextsTest.addAdditionalParameters(cases, false);
    }
}

