/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNMaxFunction;

public class MaxFunctionTest {
    private NNMaxFunction maxFunction;

    @Before
    public void setUp() {
        this.maxFunction = new NNMaxFunction();
    }

    @Test
    public void invokeNullList() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke((List)null), null);
    }

    @Test
    public void invokeEmptyList() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Collections.emptyList()), null);
    }

    @Test
    public void invokeListWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(10.2))), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListOfIntegers() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Collections.singletonList(1)), 1);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList(1, 2, 3)), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList(1, 3, 2)), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList(3, 1, 2)), 3);
    }

    @Test
    public void invokeListOfStrings() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Collections.singletonList("a")), "a");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList("a", "b", "c")), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList("a", "c", "b")), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList("c", "a", "b")), "c");
    }

    @Test
    public void invokeNullArray() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke((Object[])null), null);
    }

    @Test
    public void invokeEmptyArray() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[0]), null);
    }

    @Test
    public void invokeArrayWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke(new Object[]{1, "test", BigDecimal.valueOf(10.2)}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayOfIntegers() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{1}), 1);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{null, 1, 2, 3}), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{1, 3, null, 2}), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{3, 1, 2, null}), 3);
    }

    @Test
    public void invokeArrayOfStrings() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{"a"}), "a");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{null, "a", "b", "c"}), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{"a", null, "c", "b"}), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{"c", "a", "b", null}), "c");
    }
}

