/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSemanticMappings;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSupport;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.QuantifiedExpressionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualQuantTest {
    public static final Logger LOG = LoggerFactory.getLogger(ManualQuantTest.class);

    @Test
    public void testManualContext() {
        ManualFilterExpression compiledExpression = new ManualFilterExpression();
        LOG.debug("{}", (Object)compiledExpression);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext();
        Object result = compiledExpression.apply(emptyContext);
        LOG.debug("{}", result);
        Assertions.assertThat((Object)result).isEqualTo((Object)Boolean.TRUE);
    }

    public static class ManualFilterExpression
    implements CompiledFEELExpression {
        public static final BigDecimal K_80 = new BigDecimal(80, MathContext.DECIMAL128);
        public static final BigDecimal K_11 = new BigDecimal(11, MathContext.DECIMAL128);
        public static final BigDecimal K_100 = new BigDecimal(100, MathContext.DECIMAL128);
        public static final BigDecimal K_110 = new BigDecimal(110, MathContext.DECIMAL128);

        public Object apply(EvaluationContext feelExprCtx) {
            return CompiledFEELSupport.quant((QuantifiedExpressionNode.Quantifier)QuantifiedExpressionNode.Quantifier.SOME, (EvaluationContext)feelExprCtx).with(c -> "price", c -> Arrays.asList(K_80, K_11, K_110)).satisfies(c -> CompiledFEELSemanticMappings.gt((Object)feelExprCtx.getValue("price"), (Object)K_100));
        }
    }
}

