/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.AnyFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class AnyFunctionTest {
    private AnyFunction anyFunction;

    @Before
    public void setUp() {
        this.anyFunction = new AnyFunction();
    }

    @Test
    public void invokeBooleanParamNull() {
        FunctionTestUtil.assertResultNull(this.anyFunction.invoke((Boolean)null), new String[0]);
    }

    @Test
    public void invokeBooleanParamTrue() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Boolean.valueOf(true)), true, new String[0]);
    }

    @Test
    public void invokeBooleanParamFalse() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Boolean.valueOf(false)), false, new String[0]);
    }

    @Test
    public void invokeArrayParamNull() {
        FunctionTestUtil.assertResultError(this.anyFunction.invoke((Object[])null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeArrayParamEmptyArray() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(new Object[0]), false, new String[0]);
    }

    @Test
    public void invokeArrayParamReturnTrue() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(new Object[]{Boolean.TRUE, Boolean.TRUE}), true, new String[0]);
        FunctionTestUtil.assertResult(this.anyFunction.invoke(new Object[]{Boolean.TRUE, Boolean.FALSE}), true, new String[0]);
        FunctionTestUtil.assertResult(this.anyFunction.invoke(new Object[]{Boolean.TRUE, null}), true, new String[0]);
        FunctionTestUtil.assertResult(this.anyFunction.invoke(new Object[]{Boolean.TRUE, null, Boolean.FALSE}), true, new String[0]);
    }

    @Test
    public void invokeArrayParamReturnFalse() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(new Object[]{Boolean.FALSE, Boolean.FALSE}), false, new String[0]);
    }

    @Test
    public void invokeArrayParamReturnNull() {
        FunctionTestUtil.assertResultNull(this.anyFunction.invoke(new Object[]{Boolean.FALSE, null, Boolean.FALSE}), new String[0]);
    }

    @Test
    public void invokeArrayParamTypeHeterogenousArray() {
        FunctionTestUtil.assertResultError(this.anyFunction.invoke(new Object[]{Boolean.FALSE, 1}), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.anyFunction.invoke(new Object[]{Boolean.TRUE, 1}), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.anyFunction.invoke(new Object[]{Boolean.TRUE, null, 1}), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListParamNull() {
        FunctionTestUtil.assertResultError(this.anyFunction.invoke((List)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListParamEmptyList() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Collections.emptyList()), false, new String[0]);
    }

    @Test
    public void invokeListParamReturnTrue() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Arrays.asList(Boolean.TRUE, Boolean.TRUE)), true, new String[0]);
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Arrays.asList(Boolean.TRUE, Boolean.FALSE)), true, new String[0]);
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Arrays.asList(Boolean.TRUE, null)), true, new String[0]);
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Arrays.asList(Boolean.TRUE, null, Boolean.FALSE)), true, new String[0]);
    }

    @Test
    public void invokeListParamReturnFalse() {
        FunctionTestUtil.assertResult(this.anyFunction.invoke(Arrays.asList(Boolean.FALSE, Boolean.FALSE)), false, new String[0]);
    }

    @Test
    public void invokeListParamReturnNull() {
        FunctionTestUtil.assertResultNull(this.anyFunction.invoke(Arrays.asList(Boolean.FALSE, null, Boolean.FALSE)), new String[0]);
    }

    @Test
    public void invokeListParamTypeHeterogenousArray() {
        FunctionTestUtil.assertResultError(this.anyFunction.invoke(Arrays.asList(Boolean.FALSE, 1)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.anyFunction.invoke(Arrays.asList(Boolean.TRUE, 1)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.anyFunction.invoke(Arrays.asList(Boolean.TRUE, null, 1)), InvalidParametersEvent.class, new String[0]);
    }
}

