/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.interval;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.interval.StartsFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class StartsFunctionTest {
    private StartsFunction startsFunction;

    @Before
    public void setUp() {
        this.startsFunction = StartsFunction.INSTANCE;
    }

    @Test
    public void invokeParamIsNull() {
        FunctionTestUtil.assertResultError(this.startsFunction.invoke((Comparable)null, (Range)new RangeImpl()), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.startsFunction.invoke((Comparable)((Object)"a"), null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamsCantBeCompared() {
        FunctionTestUtil.assertResultError(this.startsFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED)), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamSingleAndRange() {
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Comparable)((Object)"a"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Comparable)((Object)"f"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Comparable)((Object)"a"), (Range)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Comparable)((Object)"a"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"b"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
    }

    @Test
    public void invokeParamRangeAndRange() {
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"f"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.startsFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
    }
}

