/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.ListContainsFunction;

public class ListContainsFunctionTest {
    private ListContainsFunction listContainsFunction;

    @Before
    public void setUp() {
        this.listContainsFunction = new ListContainsFunction();
    }

    @Test
    public void invokeListNull() {
        FunctionTestUtil.assertResultError(this.listContainsFunction.invoke((List)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.listContainsFunction.invoke(null, new Object()), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeContainsNull() {
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Collections.singletonList(null), null), true, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, null), null), true, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(null, 1), null), true, new String[0]);
    }

    @Test
    public void invokeNotContainsNull() {
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Collections.emptyList(), null), false, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Collections.singletonList(1), null), false, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, 2), null), false, new String[0]);
    }

    @Test
    public void invokeContains() {
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, 2, "test"), (Object)"test"), true, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, 2, "test"), (Object)1), true, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, 2, "test"), (Object)BigDecimal.ONE), true, new String[0]);
    }

    @Test
    public void invokeNotContains() {
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, 2, "test"), (Object)"testtt"), false, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, 2, "test"), (Object)3), false, new String[0]);
        FunctionTestUtil.assertResult(this.listContainsFunction.invoke(Arrays.asList(1, 2, "test"), (Object)BigDecimal.valueOf(3L)), false, new String[0]);
    }
}

