/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.interval;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.interval.AfterFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class AfterFunctionTest {
    private AfterFunction afterFunction;

    @Before
    public void setUp() {
        this.afterFunction = AfterFunction.INSTANCE;
    }

    @Test
    public void invokeParamIsNull() {
        FunctionTestUtil.assertResultError(this.afterFunction.invoke((Comparable)null, (Comparable)((Object)"b")), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.afterFunction.invoke((Comparable)((Object)"a"), (Comparable)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamsCantBeCompared() {
        FunctionTestUtil.assertResultError(this.afterFunction.invoke((Comparable)((Object)"a"), (Comparable)BigDecimal.valueOf(2L)), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamSingles() {
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)((Object)"a"), (Comparable)((Object)"b")), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)((Object)"a"), (Comparable)((Object)"a")), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)((Object)"b"), (Comparable)((Object)"a")), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)BigDecimal.valueOf(2L), (Comparable)BigDecimal.valueOf(1L)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)BigDecimal.valueOf(1L), (Comparable)BigDecimal.valueOf(2L)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)BigDecimal.valueOf(1L), (Comparable)BigDecimal.valueOf(1L)), Boolean.FALSE, new String[0]);
    }

    @Test
    public void invokeParamSingleAndRange() {
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)((Object)"a"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)((Object)"f"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)((Object)"f"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.OPEN)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Comparable)((Object)"g"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
    }

    @Test
    public void invokeParamRangeAndSingle() {
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"f")), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"a")), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"a")), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"b"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"a")), Boolean.TRUE, new String[0]);
    }

    @Test
    public void invokeParamRangeAndRange() {
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"g"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"f"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"f"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.afterFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"f"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.OPEN)), Boolean.TRUE, new String[0]);
    }
}

