/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSemanticMappings;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELUnaryTests;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.EvalHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualUnaryTestsTest {
    public static final Logger LOG = LoggerFactory.getLogger(ManualUnaryTestsTest.class);

    @Test
    public void testManualUnaryTests() {
        Object left = EvalHelper.coerceNumber((Object)7);
        ManualImpl1 compiledUnaryTests = new ManualImpl1();
        LOG.debug("{}", (Object)compiledUnaryTests);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext();
        List result = compiledUnaryTests.getUnaryTests().stream().map(ut -> (Boolean)ut.apply((Object)emptyContext, left)).collect(Collectors.toList());
        LOG.debug("{}", result);
        Assertions.assertThat(result).asList().containsExactly(new Object[]{true, false});
    }

    public static class ManualImpl1
    implements CompiledFEELUnaryTests {
        private static final UnaryTest UT_a = (feelExprCtx, left) -> CompiledFEELSemanticMappings.lt((Object)left, (Object)new BigDecimal(47, MathContext.DECIMAL128));
        private static final UnaryTest UT_b = (feelExprCtx, left) -> CompiledFEELSemanticMappings.lt((Object)left, (Object)new BigDecimal(1, MathContext.DECIMAL128));

        public List<UnaryTest> getUnaryTests() {
            return Arrays.asList(UT_a, UT_b);
        }
    }
}

