/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.codegen.feel11.ProcessedExpression;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.parser.feel11.profiles.KieExtendedFEELProfile;

@RunWith(value=Parameterized.class)
public class TemporalConstantFoldingParserTest {
    @Parameterized.Parameter(value=0)
    public String expression;
    static final FEEL FEEL_STRICT = FEEL.newInstance();
    static final FEEL FEEL_KIE = FEEL.newInstance(List.of(new KieExtendedFEELProfile()));

    @Parameterized.Parameters(name="{0}")
    public static Iterable<? extends Object> data() {
        return Arrays.asList("date(\"2021-02-13\")", "date(2021, 2, 13)", "date and time(\"2021-02-13T21:34:00\")", "time(\"21:34:00\"", "time(21, 34, 0)", "duration(\"P1Y\")", "duration(\"P2DT20H14M\")");
    }

    @Test
    public void testStrict() {
        CompilerContext ctx = FEEL_STRICT.newCompilerContext();
        CompiledExpression compile = FEEL_STRICT.compile(this.expression, ctx);
        ASTNode ast = this.extractAST(compile);
        Assertions.assertThat((Object)ast).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((Object)((FunctionInvocationNode)ast).getTcFolded()).isNotNull();
    }

    @Test
    public void testKie() {
        CompilerContext ctx = FEEL_KIE.newCompilerContext();
        CompiledExpression compile = FEEL_KIE.compile(this.expression, ctx);
        ASTNode ast = this.extractAST(compile);
        Assertions.assertThat((Object)ast).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((Object)((FunctionInvocationNode)ast).getTcFolded()).isNotNull();
    }

    private ASTNode extractAST(CompiledExpression compile) {
        return ((ProcessedExpression)compile).getInterpreted().getASTNode();
    }
}

