/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.runtime.events.UnknownVariableErrorEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FEELErrorMessagesTest {
    @Test
    public void unknownVariable() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("a variable name", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)2))).onEvent((FEELEvent)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).hasSize(2);
        Assertions.assertThat((Object)((FEELEvent)captor.getAllValues().get(1))).isInstanceOf(UnknownVariableErrorEvent.class);
        Assertions.assertThat((Object)((FEELEvent)captor.getAllValues().get(1)).getOffendingSymbol()).isEqualTo((Object)"a variable name");
    }

    @Test
    public void ifWithoutElse() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true then 123", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)1))).onEvent((FEELEvent)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).hasSize(1);
        Assertions.assertThat((Object)((FEELEvent)captor.getAllValues().get(0))).isInstanceOfAny(new Class[]{SyntaxErrorEvent.class});
        Assertions.assertThat((String)((FEELEvent)captor.getAllValues().get(0)).getMessage()).startsWith((CharSequence)"Detected 'if' expression without 'else' part");
    }

    @Test
    public void ifWithoutElse2() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true then 123 456", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)1))).onEvent((FEELEvent)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).hasSize(1);
        Assertions.assertThat((Object)((FEELEvent)captor.getAllValues().get(0))).isInstanceOf(SyntaxErrorEvent.class);
        Assertions.assertThat((String)((FEELEvent)captor.getAllValues().get(0)).getMessage()).isEqualTo("missing 'else' at '456'");
    }

    @Test
    public void ifWithoutThen() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)1))).onEvent((FEELEvent)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).hasSize(1);
        Assertions.assertThat((Object)((FEELEvent)captor.getAllValues().get(0))).isInstanceOf(SyntaxErrorEvent.class);
        Assertions.assertThat((String)((FEELEvent)captor.getAllValues().get(0)).getMessage()).startsWith((CharSequence)"Detected 'if' expression without 'then' part");
    }

    @Test
    public void ifWithoutThen2() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true 123", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)2))).onEvent((FEELEvent)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).hasSize(2);
        Assertions.assertThat((Object)((FEELEvent)captor.getAllValues().get(0))).isInstanceOf(SyntaxErrorEvent.class);
        Assertions.assertThat((String)((FEELEvent)captor.getAllValues().get(0)).getMessage()).startsWith((CharSequence)"missing 'then' at '123'");
        Assertions.assertThat((Object)((FEELEvent)captor.getAllValues().get(1))).isInstanceOf(SyntaxErrorEvent.class);
        Assertions.assertThat((String)((FEELEvent)captor.getAllValues().get(1)).getMessage()).startsWith((CharSequence)"Detected 'if' expression without 'then' part");
    }
}

