/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.Period;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.MinFunction;

public class MinFunctionTest {
    private MinFunction minFunction;

    @Before
    public void setUp() {
        this.minFunction = new MinFunction();
    }

    @Test
    public void invokeNullList() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke((List)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyList() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(Collections.emptyList()), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(10.2))), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListOfIntegers() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(Collections.singletonList(1)), 1, new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList(1, 2, 3)), 1, new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList(2, 1, 3)), 1, new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList(2, 3, 1)), 1, new String[0]);
    }

    @Test
    public void invokeListOfStrings() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(Collections.singletonList("a")), "a", new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList("a", "b", "c")), "a", new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList("b", "a", "c")), "a", new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList("b", "c", "a")), "a", new String[0]);
    }

    @Test
    public void invokeListOfChronoPeriods() {
        Period p1Period = Period.parse("P1Y");
        ComparablePeriod p1Comparable = ComparablePeriod.parse((CharSequence)"P1Y");
        Period p2Period = Period.parse("P1M");
        ComparablePeriod p2Comparable = ComparablePeriod.parse((CharSequence)"P1M");
        Predicate<ChronoPeriod> assertion = i -> i.get(ChronoUnit.YEARS) == 0L && i.get(ChronoUnit.MONTHS) == 1L;
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(Collections.singletonList(p2Period)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(Collections.singletonList(p2Comparable)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(Arrays.asList(p1Period, p2Period)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(Arrays.asList(p1Comparable, p2Period)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(Arrays.asList(p1Period, p2Comparable)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(Arrays.asList(p1Comparable, p2Comparable)), ChronoPeriod.class, assertion);
    }

    @Test
    public void invokeNullArray() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke((Object[])null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyArray() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(new Object[0]), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeArrayWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(new Object[]{1, "test", BigDecimal.valueOf(10.2)}), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeArrayOfIntegers() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{1}), 1, new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{1, 2, 3}), 1, new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{2, 1, 3}), 1, new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{2, 3, 1}), 1, new String[0]);
    }

    @Test
    public void invokeArrayOfStrings() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"a"}), "a", new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"a", "b", "c"}), "a", new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"b", "a", "c"}), "a", new String[0]);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"b", "c", "a"}), "a", new String[0]);
    }

    @Test
    public void invokeArrayOfChronoPeriods() {
        Period p1Period = Period.parse("P1Y");
        ComparablePeriod p1Comparable = ComparablePeriod.parse((CharSequence)"P1Y");
        Period p2Period = Period.parse("P1M");
        ComparablePeriod p2Comparable = ComparablePeriod.parse((CharSequence)"P1M");
        Predicate<ChronoPeriod> assertion = i -> i.get(ChronoUnit.YEARS) == 0L && i.get(ChronoUnit.MONTHS) == 1L;
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(new Object[]{p2Period}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(new Object[]{p2Comparable}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(new Object[]{p1Period, p2Period}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(new Object[]{p1Comparable, p2Period}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(new Object[]{p1Period, p2Comparable}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.minFunction.invoke(new Object[]{p1Comparable, p2Comparable}), ChronoPeriod.class, assertion);
    }
}

