/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.Temporal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.YearsAndMonthsFunction;

public class YearsAndMonthsFunctionTest {
    private YearsAndMonthsFunction yamFunction;

    @Before
    public void setUp() {
        this.yamFunction = new YearsAndMonthsFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.yamFunction.invoke((Temporal)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.yamFunction.invoke(null, (Temporal)LocalDate.now()), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.yamFunction.invoke((Temporal)LocalDate.now(), null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeUnsupportedTemporal() {
        FunctionTestUtil.assertResultError(this.yamFunction.invoke((Temporal)Instant.EPOCH, (Temporal)Instant.EPOCH), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.yamFunction.invoke((Temporal)LocalDate.of(2017, 1, 1), (Temporal)Instant.EPOCH), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeYear() {
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)Year.of(2017), (Temporal)Year.of(2020)), ComparablePeriod.of((int)3, (int)0, (int)0), new String[0]);
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)Year.of(2017), (Temporal)Year.of(2014)), ComparablePeriod.of((int)-3, (int)0, (int)0), new String[0]);
    }

    @Test
    public void invokeYearMonth() {
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)YearMonth.of(2017, 6), (Temporal)Year.of(2020)), ComparablePeriod.of((int)2, (int)7, (int)0), new String[0]);
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)YearMonth.of(2017, 6), (Temporal)Year.of(2014)), ComparablePeriod.of((int)-3, (int)-5, (int)0), new String[0]);
    }

    @Test
    public void invokeYearLocalDate() {
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)LocalDate.of(2017, 6, 12), (Temporal)Year.of(2020)), ComparablePeriod.of((int)2, (int)6, (int)0), new String[0]);
    }

    @Test
    public void invokeYearMonthLocalDate() {
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)LocalDate.of(2017, 6, 12), (Temporal)YearMonth.of(2020, 4)), ComparablePeriod.of((int)2, (int)9, (int)0), new String[0]);
    }

    @Test
    public void testYearsAndMonthsFunction_invokeLocalDateTime() {
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)LocalDateTime.of(2017, 6, 12, 12, 43), (Temporal)LocalDate.of(2020, 7, 13)), ComparablePeriod.of((int)3, (int)1, (int)0), new String[0]);
    }

    @Test
    public void invokeLocalDateLocalDate() {
        FunctionTestUtil.assertResult(this.yamFunction.invoke((Temporal)LocalDate.of(2017, 6, 12), (Temporal)LocalDate.of(2020, 7, 13)), ComparablePeriod.of((int)3, (int)1, (int)0), new String[0]);
    }
}

