/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.jpmml;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNInvokingjPMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNInvokingjPMMLTest.class);

    @Test
    public void testInvokeIris() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Invoke Iris.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris model.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_91c67ae0-5753-4a23-ac34-1b558a006efd", "http://www.dmg.org/PMML-4_1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)((Map)result.get("Decision")), (Matcher)Matchers.hasEntry((Object)"class", (Object)"Iris-versicolor"));
    }
}

